/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip;

import jadx.zip.IZipEntry;
import jadx.zip.IZipParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipContent
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZipContent.class);
    private final IZipParser zipParser;
    private final List<IZipEntry> entries;
    private final Map<String, IZipEntry> entriesMap;

    public ZipContent(IZipParser zipParser, List<IZipEntry> entries) {
        this.zipParser = zipParser;
        this.entries = entries;
        this.entriesMap = ZipContent.buildNameMap(zipParser, entries);
    }

    private static Map<String, IZipEntry> buildNameMap(IZipParser zipParser, List<IZipEntry> entries) {
        HashMap<String, IZipEntry> map = new HashMap<String, IZipEntry>(entries.size());
        for (IZipEntry entry : entries) {
            String name = entry.getName();
            IZipEntry prevEntry = map.put(name, entry);
            if (prevEntry == null) continue;
            LOG.warn("Found duplicate entry: {} in {}", (Object)name, (Object)zipParser);
        }
        return map;
    }

    public List<IZipEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public IZipEntry searchEntry(String fileName) {
        return this.entriesMap.get(fileName);
    }

    @Override
    public void close() throws IOException {
        this.zipParser.close();
    }
}

