/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.xapk;

import jadx.api.plugins.JadxPluginContext;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.input.xapk.data.SplitApk;
import jadx.plugins.input.xapk.data.XApkData;
import jadx.plugins.input.xapk.data.XApkManifest;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XApkLoader {
    private static final Logger LOG = LoggerFactory.getLogger(XApkLoader.class);
    private final JadxPluginContext context;
    private final Map<String, XApkData> loaded = new HashMap<String, XApkData>();

    public XApkLoader(JadxPluginContext context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public XApkData checkAndLoad(Path inputPath) {
        String fileName = inputPath.getFileName().toString();
        if (!fileName.toLowerCase(Locale.ROOT).endsWith(".xapk")) {
            return null;
        }
        try {
            XApkData loadedData = this.getLoaded(inputPath);
            if (loadedData != null) {
                return loadedData;
            }
            File xapkFile = inputPath.toFile();
            if (!FileUtils.isZipFile((File)xapkFile)) {
                return null;
            }
            try (ZipContent content = this.context.getZipReader().open(xapkFile);){
                IZipEntry manifestEntry = content.searchEntry("manifest.json");
                if (manifestEntry == null) {
                    XApkData xApkData = null;
                    return xApkData;
                }
                String manifestStr = new String(manifestEntry.getBytes(), StandardCharsets.UTF_8);
                XApkManifest xApkManifest = (XApkManifest)GsonUtils.buildGson().fromJson(manifestStr, XApkManifest.class);
                if (xApkManifest.getVersion() != 2 || xApkManifest.getSplitApks().isEmpty()) {
                    XApkData xApkData = null;
                    return xApkData;
                }
                XApkData xApkData = this.unpackXApk(xapkFile, xApkManifest, content);
                this.saveLoaded(inputPath, xApkData);
                XApkData xApkData2 = xApkData;
                return xApkData2;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load XApk file: {}", (Object)inputPath.toAbsolutePath(), (Object)e);
            return null;
        }
    }

    private XApkData unpackXApk(File xapkFile, XApkManifest xApkManifest, ZipContent content) throws IOException {
        Set declaredApks = xApkManifest.getSplitApks().stream().map(SplitApk::getFile).collect(Collectors.toSet());
        ArrayList<Path> apks = new ArrayList<Path>(declaredApks.size());
        ArrayList<Path> files = new ArrayList<Path>();
        String dirName = xapkFile.getName() + "_" + System.currentTimeMillis();
        Path tmpDir = this.context.files().getPluginTempDir().resolve(dirName);
        FileUtils.makeDirs((Path)tmpDir);
        for (IZipEntry entry : content.getEntries()) {
            String fileName = entry.getName();
            Path file = tmpDir.resolve(fileName);
            Files.write(file, entry.getBytes(), new OpenOption[0]);
            if (declaredApks.contains(fileName)) {
                apks.add(file);
                continue;
            }
            files.add(file);
        }
        return new XApkData(xApkManifest, tmpDir, apks, files);
    }

    private XApkData getLoaded(Path inputPath) throws IOException {
        return this.loaded.get(XApkLoader.pathToKey(inputPath));
    }

    private void saveLoaded(Path inputPath, XApkData xApkData) throws IOException {
        this.loaded.put(XApkLoader.pathToKey(inputPath), xApkData);
    }

    private static String pathToKey(Path path) throws IOException {
        return path.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
    }

    public synchronized void unload() {
        for (XApkData data : this.loaded.values()) {
            FileUtils.deleteDirIfExists((Path)data.getTmpDir());
        }
        this.loaded.clear();
    }
}

