/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings.utils;

import jadx.api.metadata.annotations.VarNode;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.MethodNode;
import java.util.ArrayList;
import java.util.List;

public class DalvikToJavaBytecodeUtils {
    public static Integer getMethodArgLvIndex(VarNode methodArg) {
        MethodNode mth = methodArg.getMth();
        Integer lvIndex = DalvikToJavaBytecodeUtils.getMethodArgLvIndexViaSsaVars(methodArg.getReg(), mth);
        if (lvIndex != null) {
            return lvIndex;
        }
        List args = mth.collectArgNodes();
        for (VarNode arg : args) {
            lvIndex = arg.getReg() - ((VarNode)args.get(0)).getReg() + (mth.getAccessFlags().isStatic() ? 0 : 1);
            if (!arg.equals((Object)methodArg)) continue;
            break;
        }
        return lvIndex;
    }

    public static Integer getMethodArgLvIndex(SSAVar methodArgSsaVar, MethodNode mth) {
        return DalvikToJavaBytecodeUtils.getMethodArgLvIndexViaSsaVars(methodArgSsaVar.getRegNum(), mth);
    }

    private static Integer getMethodArgLvIndexViaSsaVars(int regNum, MethodNode mth) {
        List ssaVars = mth.getSVars();
        if (!ssaVars.isEmpty()) {
            return regNum - ((SSAVar)ssaVars.get(0)).getRegNum();
        }
        return null;
    }

    public static int getMethodVarLvIndex(VarNode methodVar) {
        MethodNode mth = methodVar.getMth();
        Integer lvIndex = DalvikToJavaBytecodeUtils.getMethodVarLvIndexViaSsaVars(methodVar.getReg(), mth);
        if (lvIndex != null) {
            return lvIndex;
        }
        Integer lastArgLvIndex = mth.getAccessFlags().isStatic() ? -1 : 0;
        List args = mth.collectArgNodes();
        if (!args.isEmpty()) {
            lastArgLvIndex = DalvikToJavaBytecodeUtils.getMethodArgLvIndex((VarNode)args.get(args.size() - 1));
        }
        return lastArgLvIndex + methodVar.getReg() + (mth.getAccessFlags().isStatic() ? 0 : 1);
    }

    public static Integer getMethodVarLvIndex(SSAVar methodVarSsaVar, MethodNode mth) {
        return DalvikToJavaBytecodeUtils.getMethodVarLvIndexViaSsaVars(methodVarSsaVar.getRegNum(), mth);
    }

    private static Integer getMethodVarLvIndexViaSsaVars(int regNum, MethodNode mth) {
        List ssaVars = mth.getSVars();
        if (ssaVars.isEmpty()) {
            return null;
        }
        Integer lastArgLvIndex = mth.getAccessFlags().isStatic() ? -1 : 0;
        List args = mth.getArgRegs();
        if (!args.isEmpty()) {
            lastArgLvIndex = DalvikToJavaBytecodeUtils.getMethodArgLvIndexViaSsaVars(((RegisterArg)args.get(args.size() - 1)).getSVar().getRegNum(), mth);
        }
        return lastArgLvIndex + regNum + (mth.getAccessFlags().isStatic() ? 0 : 1);
    }

    public static Integer getMethodArgLvtIndex(VarNode methodArg) {
        MethodNode mth = methodArg.getMth();
        int lvtIndex = mth.getAccessFlags().isStatic() ? 0 : 1;
        List args = mth.collectArgNodes();
        for (VarNode arg : args) {
            if (arg.equals((Object)methodArg)) {
                return lvtIndex;
            }
            ++lvtIndex;
        }
        return null;
    }

    public static Integer getMethodArgLvtIndex(SSAVar methodArgSsaVar, MethodNode mth) {
        List ssaVars = mth.getSVars();
        if (ssaVars.isEmpty()) {
            return null;
        }
        List args = mth.getArgRegs();
        int lvtIndex = mth.getAccessFlags().isStatic() ? 0 : 1;
        for (RegisterArg arg : args) {
            if (arg.getSVar().equals((Object)methodArgSsaVar)) {
                return lvtIndex;
            }
            ++lvtIndex;
        }
        return null;
    }

    public static Integer getMethodVarLvtIndex(SSAVar methodVarSsaVar, MethodNode mth) {
        ArrayList ssaVars = new ArrayList(mth.getSVars());
        if (ssaVars.isEmpty()) {
            return null;
        }
        Integer lvtIndex = DalvikToJavaBytecodeUtils.getMethodArgLvtIndex(methodVarSsaVar, mth);
        if (lvtIndex != null) {
            return lvtIndex;
        }
        lvtIndex = mth.getAccessFlags().isStatic() ? 0 : 1;
        lvtIndex = lvtIndex + mth.getArgTypes().size();
        lvtIndex = DalvikToJavaBytecodeUtils.getMethodArgLvtIndex(methodVarSsaVar, mth) + 1;
        ssaVars.subList(0, ssaVars.indexOf(methodVarSsaVar) + 1).clear();
        int lastRegNum = -1;
        for (SSAVar ssaVar : ssaVars) {
            if (ssaVar.getRegNum() == lastRegNum) continue;
            Integer n = lvtIndex;
            Integer n2 = lvtIndex = Integer.valueOf(lvtIndex + 1);
            if (ssaVar.equals((Object)methodVarSsaVar)) {
                return lvtIndex;
            }
            lastRegNum = ssaVar.getRegNum();
        }
        return null;
    }
}

