/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings;

import jadx.api.plugins.options.OptionFlag;
import jadx.api.plugins.options.impl.BasePluginOptionsBuilder;
import jadx.core.utils.ListUtils;
import java.util.Locale;
import net.fabricmc.mappingio.format.MappingFormat;
import org.jetbrains.annotations.Nullable;

public class RenameMappingsOptions
extends BasePluginOptionsBuilder {
    public static final String INVERT_OPT = "rename-mappings.invert";
    public static final String FORMAT_OPT = "rename-mappings.format";
    private boolean invert = false;
    @Nullable
    private MappingFormat format = null;

    public void registerOptions() {
        this.option(FORMAT_OPT, MappingFormat.class).description("mapping format").parser(RenameMappingsOptions::parseMappingFormat).formatter(v -> v == null ? "AUTO" : v.name()).values(ListUtils.concat(null, (Object[])MappingFormat.values())).defaultValue(null).flags(new OptionFlag[]{OptionFlag.PER_PROJECT, OptionFlag.DISABLE_IN_GUI}).setter(v -> {
            this.format = v;
        });
        this.boolOption(INVERT_OPT).description("invert mapping on load").defaultValue((Object)false).flags(new OptionFlag[]{OptionFlag.PER_PROJECT}).setter(v -> {
            this.invert = v;
        });
    }

    private static MappingFormat parseMappingFormat(String name) {
        String upName = name.toUpperCase(Locale.ROOT);
        if (upName.equals("AUTO")) {
            return null;
        }
        return MappingFormat.valueOf((String)upName);
    }

    @Nullable
    public MappingFormat getFormat() {
        return this.format;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public String getOptionsHashString() {
        return String.valueOf(this.format) + ":" + this.invert;
    }
}

