/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.kotlin.metadata.pass;

import jadx.api.plugins.pass.JadxPassInfo;
import jadx.api.plugins.pass.impl.OrderedJadxPassInfo;
import jadx.api.plugins.pass.types.JadxPreparePass;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.plugins.kotlin.metadata.KotlinMetadataOptions;
import jadx.plugins.kotlin.metadata.model.ClassAliasRename;
import jadx.plugins.kotlin.metadata.utils.KotlinMetadataUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljadx/plugins/kotlin/metadata/pass/KotlinMetadataPreparePass;", "Ljadx/api/plugins/pass/types/JadxPreparePass;", "options", "Ljadx/plugins/kotlin/metadata/KotlinMetadataOptions;", "<init>", "(Ljadx/plugins/kotlin/metadata/KotlinMetadataOptions;)V", "getInfo", "Ljadx/api/plugins/pass/JadxPassInfo;", "init", "", "root", "Ljadx/core/dex/nodes/RootNode;", "jadx-kotlin-metadata"})
public final class KotlinMetadataPreparePass
implements JadxPreparePass {
    @NotNull
    private final KotlinMetadataOptions options;

    public KotlinMetadataPreparePass(@NotNull KotlinMetadataOptions options) {
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        this.options = options;
    }

    @NotNull
    public JadxPassInfo getInfo() {
        OrderedJadxPassInfo orderedJadxPassInfo = new OrderedJadxPassInfo("KotlinMetadataPrepare", "Use kotlin.Metadata annotation to rename class & package").before("RenameVisitor");
        Intrinsics.checkNotNullExpressionValue((Object)orderedJadxPassInfo, (String)"before(...)");
        return (JadxPassInfo)orderedJadxPassInfo;
    }

    public void init(@NotNull RootNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.options.isClassAlias()) {
            for (ClassNode cls : root.getClasses()) {
                if (cls.contains(AFlag.DONT_RENAME)) continue;
                Intrinsics.checkNotNull((Object)cls);
                ClassAliasRename kotlinCls = KotlinMetadataUtils.getAlias(cls);
                if (kotlinCls == null) continue;
                cls.rename(kotlinCls.getName());
                cls.getPackageNode().rename(kotlinCls.getPkg());
            }
        }
    }
}

