/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.shortcut;

import jadx.commons.app.JadxSystemInfo;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.KeyStroke;

public class Shortcut {
    private static final Set<Integer> FORBIDDEN_KEY_CODES = new HashSet<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(16), Integer.valueOf(18), Integer.valueOf(157), Integer.valueOf(65406)));
    private static final Set<Integer> ALLOWED_MODIFIERS = new HashSet<Integer>(List.of(Integer.valueOf(128), Integer.valueOf(256), Integer.valueOf(512), Integer.valueOf(8192), Integer.valueOf(64)));
    private Integer keyCode = null;
    private Integer modifiers = null;
    private Integer mouseButton = null;

    private Shortcut() {
    }

    public static Shortcut keyboard(int keyCode) {
        return Shortcut.keyboard(keyCode, 0);
    }

    public static Shortcut keyboard(int keyCode, int modifiers) {
        Shortcut shortcut = new Shortcut();
        shortcut.keyCode = keyCode;
        shortcut.modifiers = modifiers;
        return shortcut;
    }

    public static Shortcut mouse(int mouseButton) {
        Shortcut shortcut = new Shortcut();
        shortcut.mouseButton = mouseButton;
        return shortcut;
    }

    public static Shortcut none() {
        Shortcut shortcut = new Shortcut();
        shortcut.modifiers = 0;
        return shortcut;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public Integer getModifiers() {
        return this.modifiers;
    }

    public Integer getMouseButton() {
        return this.mouseButton;
    }

    public boolean isKeyboard() {
        return this.keyCode != null;
    }

    public boolean isMouse() {
        return this.mouseButton != null;
    }

    public boolean isNone() {
        return !this.isMouse() && !this.isKeyboard();
    }

    public boolean isValidKeyboard() {
        return this.isKeyboard() && !FORBIDDEN_KEY_CODES.contains(this.keyCode) && this.isValidModifiers();
    }

    public boolean isValidModifiers() {
        int modifiersTest = this.modifiers;
        for (Integer modifier : ALLOWED_MODIFIERS) {
            modifiersTest &= ~modifier.intValue();
        }
        return modifiersTest == 0;
    }

    public KeyStroke toKeyStroke() {
        return this.isKeyboard() ? KeyStroke.getKeyStroke(this.keyCode, this.modifiers, this.modifiers != 0 && JadxSystemInfo.IS_MAC) : null;
    }

    public String toString() {
        if (this.isKeyboard()) {
            return this.keyToString();
        }
        if (this.isMouse()) {
            return this.mouseToString();
        }
        return "NONE";
    }

    public String getTypeString() {
        if (this.isKeyboard()) {
            return "Keyboard";
        }
        if (this.isMouse()) {
            return "Mouse";
        }
        return null;
    }

    private String mouseToString() {
        return "MouseButton" + this.mouseButton;
    }

    private String keyToString() {
        StringBuilder sb = new StringBuilder();
        if (this.modifiers != null && this.modifiers > 0) {
            sb.append(KeyEvent.getModifiersExText(this.modifiers));
            sb.append('+');
        }
        if (this.keyCode != null && this.keyCode != 0) {
            sb.append(KeyEvent.getKeyText(this.keyCode));
        } else {
            sb.append("UNDEFINED");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shortcut shortcut = (Shortcut)o;
        return Objects.equals(this.keyCode, shortcut.keyCode) && Objects.equals(this.modifiers, shortcut.modifiers) && Objects.equals(this.mouseButton, shortcut.mouseButton);
    }

    public int hashCode() {
        return Objects.hash(this.keyCode, this.modifiers, this.mouseButton);
    }
}

