/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.QuickTabsBaseNode;
import jadx.gui.ui.tab.QuickTabsChildNode;
import jadx.gui.ui.tab.TabsController;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;

abstract class QuickTabsParentNode
extends QuickTabsBaseNode {
    private final TabsController tabsController;
    private final Map<JNode, QuickTabsChildNode> childrenMap = new HashMap<JNode, QuickTabsChildNode>();

    protected QuickTabsParentNode(TabsController tabsController) {
        this.tabsController = tabsController;
    }

    public boolean addJNode(JNode node) {
        if (this.childrenMap.containsKey(node)) {
            return false;
        }
        QuickTabsChildNode childNode = new QuickTabsChildNode(node);
        this.childrenMap.put(node, childNode);
        this.add(childNode);
        return true;
    }

    public boolean removeJNode(JNode node) {
        QuickTabsChildNode childNode = this.childrenMap.remove(node);
        if (childNode == null) {
            return false;
        }
        this.remove(childNode);
        return true;
    }

    public void removeAllNodes() {
        this.removeAllChildren();
    }

    public QuickTabsChildNode getQuickTabsNode(JNode node) {
        return this.childrenMap.get(node);
    }

    public TabsController getTabsController() {
        return this.tabsController;
    }

    abstract String getTitle();

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return super.onTreePopupMenu(mainWindow);
    }
}

