/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.ui.tab.TabbedPane;

public class EditorSyncManager
implements ITabStatesListener {
    private final MainWindow mainWindow;
    private final TabbedPane tabbedPane;

    public EditorSyncManager(MainWindow mainWindow, TabbedPane tabbedPane) {
        this.mainWindow = mainWindow;
        this.tabbedPane = tabbedPane;
        mainWindow.getTabsController().addListener(this);
    }

    public void sync() {
        ContentPanel selectedContentPanel = this.tabbedPane.getSelectedContentPanel();
        if (selectedContentPanel != null) {
            this.mainWindow.selectNodeInTree(selectedContentPanel.getNode());
        }
    }

    @Override
    public void onTabSelect(TabBlueprint blueprint) {
        ContentPanel selectedContentPanel;
        this.mainWindow.toggleHexViewMenu();
        if (this.mainWindow.getSettings().isAlwaysSelectOpened() && (selectedContentPanel = this.tabbedPane.getSelectedContentPanel()) != null && selectedContentPanel.getNode().equals(blueprint.getNode())) {
            this.sync();
        }
    }

    @Override
    public void onTabClose(TabBlueprint blueprint) {
        ITabStatesListener.super.onTabClose(blueprint);
        this.mainWindow.toggleHexViewMenu();
    }
}

