/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.exbin.bined.CodeAreaCaretListener;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.SelectionChangedListener;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.swing.section.SectCodeArea;

public class HexEditorHeader
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String HEX_ALPHABET = "0123456789ABCDEF";
    private final SectCodeArea parent;
    private final DataChangedListener dataChangedListener = this::repaint;
    private final CodeAreaCaretListener caretMovedListener = caretPosition -> this.repaint();
    private final SelectionChangedListener selectionChangedListener = this::repaint;
    private Dimension minimumSize = null;
    private Dimension preferredSize = null;

    public HexEditorHeader(SectCodeArea parent) {
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addCaretMovedListener(this.caretMovedListener);
            this.parent.addSelectionChangedListener(this.selectionChangedListener);
            this.parent.addDataChangedListener(this.dataChangedListener);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.parent != null) {
            this.parent.addCaretMovedListener(this.caretMovedListener);
            this.parent.addSelectionChangedListener(this.selectionChangedListener);
            this.parent.addDataChangedListener(this.dataChangedListener);
        }
    }

    @Override
    public void removeNotify() {
        if (this.parent != null) {
            this.parent.removeCaretMovedListener(this.caretMovedListener);
            this.parent.removeSelectionChangedListener(this.selectionChangedListener);
            this.parent.removeDataChangedListener(this.dataChangedListener);
        }
        super.removeNotify();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Insets i = this.getInsets();
        FontMetrics fm = this.getFontMetrics(this.parent.getFont());
        if (fm == null) {
            return new Dimension(100, 20);
        }
        int ch = fm.getHeight() + 2;
        int cw = fm.stringWidth(HEX_ALPHABET) / 16;
        String sampleText = "Sel: 00000000:00000000 Len: 00000000/00000000 TXT UTF-8";
        int minTextWidth = fm.stringWidth(sampleText);
        int minimumWidth = minTextWidth + cw * 5 + i.left + i.right;
        int minimumHeight = ch + 5 + i.top + i.bottom;
        return new Dimension(minimumWidth, minimumHeight);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        this.minimumSize = minimumSize;
        this.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Insets i = this.getInsets();
        FontMetrics fm = this.getFontMetrics(this.parent.getFont());
        if (fm == null) {
            return this.getMinimumSize();
        }
        int ch = fm.getHeight() + 2;
        int cw = fm.stringWidth(HEX_ALPHABET) / 16;
        String sampleText = "Sel: 00000000:00000000 Len: 00000000/00000000 TXT UTF-8";
        int preferredTextWidth = fm.stringWidth(sampleText);
        int preferredWidth = preferredTextWidth + cw * 10 + i.left + i.right;
        int preferredHeight = ch + 5 + i.top + i.bottom;
        return new Dimension(preferredWidth, preferredHeight);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
        this.revalidate();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Insets i = this.getInsets();
        int fw = this.getWidth();
        int fh = this.getHeight();
        int w = fw - i.left - i.right;
        int h = fh - i.top - i.bottom;
        g.setFont(this.parent.getFont());
        FontMetrics fm = g.getFontMetrics();
        if (fm == null) {
            return;
        }
        int ca = fm.getAscent() + 1;
        int ch = fm.getHeight() + 2;
        int cw = fm.stringWidth(HEX_ALPHABET) / 16;
        if (cw <= 0) {
            cw = 1;
        }
        Color separatorForeground = UIManager.getColor("Separator.foreground");
        Color themeBackground = UIManager.getColor("Panel.background");
        Color themeForeground = UIManager.getColor("Panel.foreground");
        SelectionRange selectionRange = this.parent.getSelection();
        long ss = selectionRange.getStart();
        long se = selectionRange.getEnd();
        long sl = selectionRange.getLength();
        long length = this.parent.getDataSize();
        int ty = i.top + (h - ch) / 2 + ca;
        g.setColor(themeBackground);
        g.fillRect(i.left, i.top, w, h);
        g.setColor(themeForeground);
        int currentX = i.left + cw / 2;
        String selLabel = "Sel:";
        g.drawString(selLabel, currentX, ty);
        String sss = this.addressString(ss);
        g.drawString(sss, currentX += fm.stringWidth(selLabel) + cw, ty);
        String separator1 = ":";
        g.drawString(separator1, currentX += fm.stringWidth(sss), ty);
        String ses = this.addressString(se);
        g.drawString(ses, currentX += fm.stringWidth(separator1), ty);
        int dividerTopY = i.top;
        int dividerHeight = h;
        g.setColor(separatorForeground);
        g.fillRect(currentX += fm.stringWidth(ses) + cw, dividerTopY, 1, dividerHeight);
        g.setColor(themeForeground);
        String lenLabel = "Len:";
        g.drawString(lenLabel, currentX += cw, ty);
        String sls = this.addressString(sl);
        g.drawString(sls, currentX += fm.stringWidth(lenLabel) + cw, ty);
        String separator2 = "/";
        g.drawString(separator2, currentX += fm.stringWidth(sls), ty);
        String ls = this.addressString(length);
        g.drawString(ls, currentX += fm.stringWidth(separator2), ty);
        g.setColor(separatorForeground);
        g.fillRect(currentX += fm.stringWidth(ls) + cw, dividerTopY, 1, dividerHeight);
        currentX += cw;
        g.setColor(themeForeground);
        String statusTxtHex = "HEX";
        CodeAreaSection section = this.parent.getActiveSection();
        if (section == BasicCodeAreaSection.TEXT_PREVIEW) {
            statusTxtHex = "TXT";
        }
        g.drawString(statusTxtHex, currentX, ty);
        g.setColor(separatorForeground);
        g.fillRect(currentX += fm.stringWidth(statusTxtHex) + cw, dividerTopY, 1, dividerHeight);
        g.setColor(themeForeground);
        String statusCharset = this.parent.getCharset().name();
        g.drawString(statusCharset, currentX += cw, ty);
        g.setColor(separatorForeground);
        g.fillRect(i.left, i.top + h - 1, w, 1);
    }

    public String addressString(long address) {
        return String.format("%08X", address);
    }
}

