/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.commons.app.JadxSystemInfo;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class JadxEventQueue
extends EventQueue {
    private static final boolean IS_X_TOOLKIT = JadxSystemInfo.IS_LINUX && "sun.awt.X11.XToolkit".equals(Toolkit.getDefaultToolkit().getClass().getName());

    public static void register() {
        if (IS_X_TOOLKIT) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(new JadxEventQueue());
        }
    }

    private JadxEventQueue() {
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        AWTEvent mappedEvent = JadxEventQueue.mapEvent(event);
        super.dispatchEvent(mappedEvent);
    }

    private static AWTEvent mapEvent(AWTEvent event) {
        if (IS_X_TOOLKIT && event instanceof MouseEvent && ((MouseEvent)event).getButton() > 3) {
            return JadxEventQueue.mapXWindowMouseEvent((MouseEvent)event);
        }
        return event;
    }

    private static AWTEvent mapXWindowMouseEvent(MouseEvent src) {
        if (src.getButton() < 6) {
            int modifiers = src.getModifiers() | 0x40;
            return new MouseWheelEvent(src.getComponent(), 507, src.getWhen(), modifiers, src.getX(), src.getY(), 0, false, 0, src.getClickCount(), src.getButton() == 4 ? -1 : 1);
        }
        int modifiers = src.getModifiers() | 1 << 8 + src.getButton();
        return new MouseEvent(src.getComponent(), src.getID(), src.getWhen(), modifiers, src.getX(), src.getY(), 1, src.isPopupTrigger(), src.getButton() - 2);
    }
}

