/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ICodeNode;
import jadx.gui.jobs.SimpleTask;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRenameNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.popupmenu.JClassPopupMenu;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.Icons;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JClass
extends JLoadableNode
implements JRenameNode {
    private static final long serialVersionUID = -1239986875244097177L;
    private static final ImageIcon ICON_CLASS_ABSTRACT = UiUtils.openSvgIcon("nodes/abstractClass");
    private static final ImageIcon ICON_CLASS_PUBLIC = UiUtils.openSvgIcon("nodes/publicClass");
    private static final ImageIcon ICON_CLASS_PRIVATE = UiUtils.openSvgIcon("nodes/privateClass");
    private static final ImageIcon ICON_CLASS_PROTECTED = UiUtils.openSvgIcon("nodes/protectedClass");
    private static final ImageIcon ICON_INTERFACE = UiUtils.openSvgIcon("nodes/interface");
    private static final ImageIcon ICON_ENUM = UiUtils.openSvgIcon("nodes/enum");
    private static final ImageIcon ICON_ANNOTATION = UiUtils.openSvgIcon("nodes/annotationtype");
    private final transient JavaClass cls;
    private final transient JClass jParent;
    private final transient JNodeCache nodeCache;
    private transient boolean loaded;

    public JClass(JavaClass cls, JClass parent, JNodeCache nodeCache) {
        this.cls = cls;
        this.jParent = parent;
        this.loaded = parent != null;
        this.nodeCache = nodeCache;
    }

    public JavaClass getCls() {
        return this.cls;
    }

    @Override
    public boolean canRename() {
        return !this.cls.getClassNode().contains(AFlag.DONT_RENAME);
    }

    @Override
    public void loadNode() {
        this.getRootClass().load();
    }

    @Override
    @Nullable
    public synchronized SimpleTask getLoadTask() {
        if (this.loaded) {
            return null;
        }
        JClass rootClass = this.getRootClass();
        return new SimpleTask(NLS.str("progress.decompile"), () -> rootClass.getCls().getClassNode().decompile(), rootClass::load);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.cls.decompile();
        this.loaded = true;
        this.update();
    }

    public synchronized ICodeInfo reload(CacheObject cache) {
        cache.getNodeCache().removeWholeClass(this.cls);
        ICodeInfo codeInfo = this.cls.reload();
        this.loaded = true;
        this.update();
        return codeInfo;
    }

    public synchronized void unload(CacheObject cache) {
        cache.getNodeCache().removeWholeClass(this.cls);
        this.cls.unload();
        this.loaded = false;
    }

    public synchronized void update() {
        this.removeAllChildren();
        if (!this.loaded) {
            this.add(new TextNode(NLS.str("tree.loading")));
        } else {
            for (JavaClass javaClass : this.cls.getInnerClasses()) {
                JClass innerCls = this.nodeCache.makeFrom(javaClass);
                this.add(innerCls);
                innerCls.update();
            }
            for (JavaField f : this.cls.getFields()) {
                this.add(this.nodeCache.makeFrom((JavaNode)f));
            }
            for (JavaMethod m : this.cls.getMethods()) {
                this.add(this.nodeCache.makeFrom((JavaNode)m));
            }
        }
    }

    @Override
    public ICodeInfo getCodeInfo() {
        return this.cls.getCodeInfo();
    }

    @Override
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return new ClassCodeContentPanel(tabbedPane, this);
    }

    public String getSmali() {
        return this.cls.getSmali();
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return new JClassPopupMenu(mainWindow, this);
    }

    @Override
    public Icon getIcon() {
        AccessInfo accessInfo = this.cls.getAccessInfo();
        if (accessInfo.isEnum()) {
            return ICON_ENUM;
        }
        if (accessInfo.isAnnotation()) {
            return ICON_ANNOTATION;
        }
        if (accessInfo.isInterface()) {
            return ICON_INTERFACE;
        }
        if (accessInfo.isAbstract()) {
            return ICON_CLASS_ABSTRACT;
        }
        if (accessInfo.isProtected()) {
            return ICON_CLASS_PROTECTED;
        }
        if (accessInfo.isPrivate()) {
            return ICON_CLASS_PRIVATE;
        }
        if (accessInfo.isPublic()) {
            return ICON_CLASS_PUBLIC;
        }
        return Icons.CLASS;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.cls;
    }

    public ICodeNode getCodeNodeRef() {
        return this.cls.getClassNode();
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    @Override
    public JClass getRootClass() {
        if (this.jParent == null) {
            return this;
        }
        return this.jParent.getRootClass();
    }

    @Override
    public String getName() {
        return this.cls.getName();
    }

    public String getFullName() {
        return this.cls.getFullName();
    }

    @Override
    public String getTitle() {
        return this.makeLongStringHtml();
    }

    @Override
    public boolean isValidName(String newName) {
        if (NameMapper.isValidIdentifier((String)newName)) {
            return true;
        }
        if (this.cls.isInner()) {
            return false;
        }
        if (NameMapper.isValidFullIdentifier((String)newName)) {
            return true;
        }
        return newName.startsWith(".") && NameMapper.isValidIdentifier((String)newName.substring(1));
    }

    @Override
    public ICodeRename buildCodeRename(String newName, Set<ICodeRename> renames) {
        return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forCls((JavaClass)this.cls), newName);
    }

    @Override
    public void removeAlias() {
        this.cls.getClassNode().rename("");
    }

    @Override
    public void addUpdateNodes(List<JavaNode> toUpdate) {
        toUpdate.add((JavaNode)this.cls);
        toUpdate.addAll(this.cls.getUseIn());
    }

    @Override
    public void reload(MainWindow mainWindow) {
        mainWindow.reloadTreePreservingState();
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JClass && this.cls.equals((Object)((JClass)obj).cls);
    }

    @Override
    public String makeString() {
        return this.cls.getName();
    }

    @Override
    public String makeLongString() {
        return this.cls.getFullName();
    }

    public int compareToCls(@NotNull JClass otherCls) {
        return this.getCls().getRawName().compareTo(otherCls.getCls().getRawName());
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        if (other instanceof JClass) {
            return this.compareToCls((JClass)other);
        }
        if (other instanceof JMethod) {
            int cmp = this.compareToCls(other.getJParent());
            if (cmp != 0) {
                return cmp;
            }
            return -1;
        }
        return super.compareTo(other);
    }
}

