/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.JavaClass;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.providers.BaseSearchProvider;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class MethodSearchProvider
extends BaseSearchProvider {
    private int clsNum = 0;
    private int mthNum = 0;

    public MethodSearchProvider(MainWindow mw, SearchSettings searchSettings, List<JavaClass> classes) {
        super(mw, searchSettings, classes);
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        if (this.classes.isEmpty()) {
            return null;
        }
        while (true) {
            if (cancelable.isCanceled()) {
                return null;
            }
            JavaClass cls = (JavaClass)this.classes.get(this.clsNum);
            List methods = cls.getClassNode().getMethods();
            if (this.mthNum < methods.size()) {
                MethodNode mth;
                if (!this.checkMth((mth = (MethodNode)methods.get(this.mthNum++)).getMethodInfo())) continue;
                return this.convert((ICodeNode)mth);
            }
            ++this.clsNum;
            this.mthNum = 0;
            if (this.clsNum >= this.classes.size()) break;
        }
        return null;
    }

    private boolean checkMth(MethodInfo mthInfo) {
        return this.isMatch(mthInfo.getShortId()) || this.isMatch(mthInfo.getAlias()) || this.isMatch(mthInfo.getFullId()) || this.isMatch(mthInfo.getAliasFullName());
    }

    @Override
    public int progress() {
        return this.clsNum;
    }
}

