/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.JavaClass;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.providers.BaseSearchProvider;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class FieldSearchProvider
extends BaseSearchProvider {
    private int clsNum = 0;
    private int fldNum = 0;

    public FieldSearchProvider(MainWindow mw, SearchSettings searchSettings, List<JavaClass> classes) {
        super(mw, searchSettings, classes);
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        while (true) {
            if (cancelable.isCanceled()) {
                return null;
            }
            JavaClass cls = (JavaClass)this.classes.get(this.clsNum);
            List fields = cls.getClassNode().getFields();
            if (this.fldNum < fields.size()) {
                FieldNode fld;
                if (!this.checkField((fld = (FieldNode)fields.get(this.fldNum++)).getFieldInfo())) continue;
                return this.convert((ICodeNode)fld);
            }
            ++this.clsNum;
            this.fldNum = 0;
            if (this.clsNum >= this.classes.size()) break;
        }
        return null;
    }

    private boolean checkField(FieldInfo fieldInfo) {
        return this.isMatch(fieldInfo.getName()) || this.isMatch(fieldInfo.getAlias()) || this.isMatch(fieldInfo.getFullId());
    }

    @Override
    public int progress() {
        return this.clsNum;
    }
}

