/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search;

import jadx.gui.search.SearchSettings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public interface ISearchMethod {
    public int find(String var1, String var2, int var3);

    public static ISearchMethod build(SearchSettings searchSettings) {
        if (searchSettings.isUseRegex()) {
            Pattern pattern = searchSettings.getPattern();
            return (input, subStr, start) -> {
                Matcher matcher = pattern.matcher(input);
                if (matcher.find(start)) {
                    return matcher.start();
                }
                return -1;
            };
        }
        if (searchSettings.isIgnoreCase()) {
            return StringUtils::indexOfIgnoreCase;
        }
        return String::indexOf;
    }
}

