/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code.disk;

import jadx.api.ICodeInfo;
import jadx.api.impl.AnnotatedCodeInfo;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import jadx.gui.cache.code.disk.adapters.CodeAnnotationAdapter;
import jadx.gui.cache.code.disk.adapters.DataAdapterHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CodeMetadataAdapter {
    private static final byte[] JADX_METADATA_HEADER = "jadxmd".getBytes(StandardCharsets.US_ASCII);
    private final CodeAnnotationAdapter codeAnnotationAdapter;

    public CodeMetadataAdapter(RootNode root) {
        this.codeAnnotationAdapter = new CodeAnnotationAdapter(root);
    }

    public void write(Path metadataFile, ICodeMetadata metadata) {
        FileUtils.makeDirsForFile((Path)metadataFile);
        try (OutputStream fileOutput = Files.newOutputStream(metadataFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fileOutput));){
            out.write(JADX_METADATA_HEADER);
            this.writeLines(out, metadata.getLineMapping());
            this.writeAnnotations(out, metadata.getAsMap());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write metadata file", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ICodeInfo readAndBuild(Path metadataFile, String code) {
        if (!Files.exists(metadataFile, new LinkOption[0])) {
            return new SimpleCodeInfo(code);
        }
        try (InputStream fileInput = Files.newInputStream(metadataFile, new OpenOption[0]);){
            AnnotatedCodeInfo annotatedCodeInfo;
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(fileInput));){
                in.skipBytes(JADX_METADATA_HEADER.length);
                Map<Integer, Integer> lines = this.readLines(in);
                Map<Integer, ICodeAnnotation> annotations = this.readAnnotations(in);
                annotatedCodeInfo = new AnnotatedCodeInfo(code, lines, annotations);
            }
            return annotatedCodeInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse code annotations", e);
        }
    }

    private void writeLines(DataOutput out, Map<Integer, Integer> lines) throws IOException {
        out.writeInt(lines.size());
        for (Map.Entry<Integer, Integer> entry : lines.entrySet()) {
            DataAdapterHelper.writeUVInt(out, entry.getKey());
            DataAdapterHelper.writeUVInt(out, entry.getValue());
        }
    }

    private Map<Integer, Integer> readLines(DataInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> lines = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            int key = DataAdapterHelper.readUVInt(in);
            int value = DataAdapterHelper.readUVInt(in);
            lines.put(key, value);
        }
        return lines;
    }

    private void writeAnnotations(DataOutputStream out, Map<Integer, ICodeAnnotation> annotations) throws IOException {
        out.writeInt(annotations.size());
        for (Map.Entry<Integer, ICodeAnnotation> entry : annotations.entrySet()) {
            DataAdapterHelper.writeUVInt(out, entry.getKey());
            this.codeAnnotationAdapter.write((DataOutput)out, entry.getValue());
        }
    }

    private Map<Integer, ICodeAnnotation> readAnnotations(DataInputStream in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, ICodeAnnotation> map = new HashMap<Integer, ICodeAnnotation>(size);
        for (int i = 0; i < size; ++i) {
            int pos = DataAdapterHelper.readUVInt(in);
            ICodeAnnotation ann = this.codeAnnotationAdapter.read(in);
            if (ann == null) continue;
            map.put(pos, ann);
        }
        return map;
    }
}

