/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.nodes.IDexNode;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorsCounter.class);
    private static final boolean PRINT_MTH_SIZE = false;
    private final Set<IAttributeNode> errorNodes = new HashSet<IAttributeNode>();
    private int errorsCount;
    private final Set<IAttributeNode> warnNodes = new HashSet<IAttributeNode>();
    private int warnsCount;

    public static <N extends IDexNode & IAttributeNode> String error(N node, String warnMsg, Throwable th) {
        return node.root().getErrorsCounter().addError(node, warnMsg, th);
    }

    public static <N extends IDexNode & IAttributeNode> void warning(N node, String warnMsg) {
        node.root().getErrorsCounter().addWarning(node, warnMsg);
    }

    public static String formatMsg(IDexNode node, String msg) {
        return msg + " in " + node.typeName() + ": " + String.valueOf(node) + ", file: " + node.getInputFileName();
    }

    private synchronized <N extends IDexNode & IAttributeNode> String addError(N node, String error, @Nullable Throwable e) {
        this.errorNodes.add(node);
        ++this.errorsCount;
        String msg = ErrorsCounter.formatMsg(node, error);
        if (e == null) {
            LOG.error(msg);
        } else if (e instanceof StackOverflowError) {
            LOG.error("{}, error: StackOverflowError", (Object)msg);
        } else if (e instanceof JadxOverflowException) {
            String details = e.getMessage();
            e = new JadxOverflowException(details);
            if (details == null || details.isEmpty()) {
                LOG.error("{}", (Object)msg);
            } else {
                LOG.error("{}, details: {}", (Object)msg, (Object)details);
            }
        } else {
            LOG.error(msg, e);
        }
        ((IAttributeNode)node).addAttr(AType.JADX_ERROR, new JadxError(error, e));
        return msg;
    }

    private synchronized <N extends IDexNode & IAttributeNode> void addWarning(N node, String warn) {
        this.warnNodes.add(node);
        ++this.warnsCount;
        LOG.warn(ErrorsCounter.formatMsg(node, warn));
    }

    public void printReport() {
        if (this.getErrorCount() > 0) {
            LOG.error("{} errors occurred in following nodes:", (Object)this.getErrorCount());
            ArrayList<CallSite> errors = new ArrayList<CallSite>(this.errorNodes.size());
            for (IAttributeNode iAttributeNode : this.errorNodes) {
                String nodeName = iAttributeNode.getClass().getSimpleName().replace("Node", "");
                errors.add((CallSite)((Object)(nodeName + ": " + String.valueOf(iAttributeNode))));
            }
            Collections.sort(errors);
            for (String string : errors) {
                LOG.error("  {}", (Object)string);
            }
        }
        if (this.getWarnsCount() > 0) {
            LOG.warn("{} warnings in {} nodes", (Object)this.getWarnsCount(), (Object)this.warnNodes.size());
        }
    }

    public int getErrorCount() {
        return this.errorsCount;
    }

    public int getWarnsCount() {
        return this.warnsCount;
    }

    public Set<IAttributeNode> getErrorNodes() {
        return this.errorNodes;
    }

    public Set<IAttributeNode> getWarnNodes() {
        return this.warnNodes;
    }
}

