/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.attributes.nodes.TmpEdgeAttr;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.DebugChecksPass;
import jadx.core.utils.DebugUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class DebugChecks {
    private static final Set<String> IGNORE_CHECKS = new HashSet<String>(List.of("PrepareForCodeGen", "RenameVisitor", "DotGraphVisitor"));

    public static List<IDexTreeVisitor> insertPasses(List<IDexTreeVisitor> passes) {
        int size = passes.size();
        ArrayList<IDexTreeVisitor> list = new ArrayList<IDexTreeVisitor>(size * 2);
        for (IDexTreeVisitor pass : passes) {
            list.add(pass);
            String name = pass.getName();
            if (IGNORE_CHECKS.contains(name)) continue;
            list.add(new DebugChecksPass(name));
        }
        return list;
    }

    public static void runChecksAfterVisitor(MethodNode mth, String visitor) {
        try {
            DebugChecks.checkMethod(mth);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Debug check failed after visitor: " + visitor, e);
        }
    }

    public static void checkMethod(MethodNode mth) {
        List<BlockNode> basicBlocks = mth.getBasicBlocks();
        if (Utils.isEmpty(basicBlocks)) {
            return;
        }
        for (BlockNode block : basicBlocks) {
            for (InsnNode insn : block.getInstructions()) {
                DebugChecks.checkInsn(mth, block, insn);
            }
        }
        DebugChecks.checkSSAVars(mth);
    }

    private static void checkInsn(MethodNode mth, BlockNode block, InsnNode insn) {
        if (insn.getResult() != null) {
            DebugChecks.checkVar(mth, insn, insn.getResult());
        }
        for (InsnArg insnArg : insn.getArguments()) {
            if (insnArg instanceof RegisterArg) {
                DebugChecks.checkVar(mth, insn, (RegisterArg)insnArg);
                continue;
            }
            if (!insnArg.isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)insnArg).getWrapInsn();
            DebugChecks.checkInsn(mth, block, wrapInsn);
        }
        switch (insn.getType()) {
            case TERNARY: {
                TernaryInsn ternaryInsn = (TernaryInsn)insn;
                for (RegisterArg arg : ternaryInsn.getCondition().getRegisterArgs()) {
                    DebugChecks.checkVar(mth, insn, arg);
                }
                break;
            }
            case IF: {
                int branches;
                IfNode ifNode = (IfNode)insn;
                if (!ifNode.getThenBlock().equals(ifNode.getElseBlock()) && (branches = (int)block.getSuccessors().stream().filter(b -> !DebugChecks.hasTmpEdge(block, b)).count()) != 2) {
                    DebugUtils.dumpRaw(mth, "error");
                    throw new JadxRuntimeException("Incorrect if block successors count: " + branches + " (expect 2), block: " + String.valueOf(block));
                }
                DebugChecks.checkBlock(mth, ifNode.getThenBlock(), () -> "then block in if insn: " + String.valueOf(ifNode));
                DebugChecks.checkBlock(mth, ifNode.getElseBlock(), () -> "else block in if insn: " + String.valueOf(ifNode));
            }
        }
    }

    private static boolean hasTmpEdge(BlockNode start, BlockNode end) {
        TmpEdgeAttr tmpEdgeAttr = end.get(AType.TMP_EDGE);
        if (tmpEdgeAttr == null) {
            return false;
        }
        return tmpEdgeAttr.getBlock().equals(start);
    }

    private static void checkBlock(MethodNode mth, BlockNode block, Supplier<String> source) {
        if (!mth.getBasicBlocks().contains(block)) {
            throw new JadxRuntimeException("Block not registered in method: " + String.valueOf(block) + " from " + source.get());
        }
    }

    private static void checkVar(MethodNode mth, InsnNode insn, RegisterArg reg) {
        DebugChecks.checkRegisterArg(mth, reg);
        SSAVar sVar = reg.getSVar();
        if (sVar == null) {
            if (reg.contains(AFlag.DONT_GENERATE) || insn.contains(AFlag.DONT_GENERATE)) {
                return;
            }
            if (Utils.notEmpty(mth.getSVars())) {
                throw new JadxRuntimeException("Null SSA var in " + String.valueOf(reg) + " at " + String.valueOf(insn));
            }
            return;
        }
        if (Utils.indexInListByRef(mth.getSVars(), sVar) == -1) {
            throw new JadxRuntimeException("SSA var not present in method vars list, var: " + String.valueOf(sVar) + " from insn: " + String.valueOf(insn));
        }
        RegisterArg resArg = insn.getResult();
        List<RegisterArg> useList = sVar.getUseList();
        if (resArg == reg) {
            if (sVar.getAssignInsn() != insn) {
                throw new JadxRuntimeException("Incorrect assign in ssa var: " + String.valueOf(sVar) + "\n expected: " + String.valueOf(sVar.getAssignInsn()) + "\n got: " + String.valueOf(insn));
            }
        } else if (!Utils.containsInListByRef(useList, reg)) {
            throw new JadxRuntimeException("Incorrect use list in ssa var: " + String.valueOf(sVar) + ", register not listed.\n insn: " + String.valueOf(insn));
        }
        for (RegisterArg useArg : useList) {
            DebugChecks.checkRegisterArg(mth, useArg);
        }
    }

    private static void checkSSAVars(MethodNode mth) {
        for (SSAVar ssaVar : mth.getSVars()) {
            RegisterArg assignArg = ssaVar.getAssign();
            if (assignArg.contains(AFlag.REMOVE)) continue;
            InsnNode assignInsn = assignArg.getParentInsn();
            if (assignInsn != null) {
                if (DebugChecks.insnMissing(mth, assignInsn)) {
                    throw new JadxRuntimeException("Insn not found for assign arg in SSAVar: " + String.valueOf(ssaVar) + ", insn: " + String.valueOf(assignInsn));
                }
                RegisterArg resArg = assignInsn.getResult();
                if (resArg == null) {
                    throw new JadxRuntimeException("SSA assign insn result missing. SSAVar: " + String.valueOf(ssaVar) + ", insn: " + String.valueOf(assignInsn));
                }
                SSAVar assignVar = resArg.getSVar();
                if (!assignVar.equals(ssaVar)) {
                    throw new JadxRuntimeException("Unexpected SSAVar in assign. Expected: " + String.valueOf(ssaVar) + ", got: " + String.valueOf(assignVar) + ", insn: " + String.valueOf(assignInsn));
                }
            }
            for (RegisterArg arg : ssaVar.getUseList()) {
                InsnNode useInsn = arg.getParentInsn();
                if (useInsn == null) {
                    throw new JadxRuntimeException("Parent insn can't be null for arg in use list of SSAVar: " + String.valueOf(ssaVar));
                }
                if (DebugChecks.insnMissing(mth, useInsn)) {
                    throw new JadxRuntimeException("Insn not found for use arg for SSAVar: " + String.valueOf(ssaVar) + ", insn: " + String.valueOf(useInsn));
                }
                int argIndex = useInsn.getArgIndex(arg);
                if (argIndex == -1) {
                    throw new JadxRuntimeException("Use arg not found in insn for SSAVar: " + String.valueOf(ssaVar) + ", insn: " + String.valueOf(useInsn));
                }
                InsnArg foundArg = useInsn.getArg(argIndex);
                if (foundArg.equals(arg)) continue;
                throw new JadxRuntimeException("Incorrect use arg in insn for SSAVar: " + String.valueOf(ssaVar) + ", insn: " + String.valueOf(useInsn) + ", arg: " + String.valueOf(foundArg));
            }
        }
    }

    private static boolean insnMissing(MethodNode mth, InsnNode insn) {
        if (insn.contains(AFlag.HIDDEN)) {
            return false;
        }
        BlockNode block = BlockUtils.getBlockByInsn(mth, insn);
        return block == null;
    }

    private static void checkRegisterArg(MethodNode mth, RegisterArg reg) {
        InsnNode parentInsn = reg.getParentInsn();
        if (parentInsn == null) {
            if (reg.contains(AFlag.METHOD_ARGUMENT)) {
                return;
            }
            throw new JadxRuntimeException("Null parentInsn for reg: " + String.valueOf(reg));
        }
        if (!parentInsn.contains(AFlag.HIDDEN)) {
            if (parentInsn.getResult() != reg && !parentInsn.containsArg(reg)) {
                throw new JadxRuntimeException("Incorrect parentInsn: " + String.valueOf(parentInsn) + ", must contains arg: " + String.valueOf(reg));
            }
            BlockNode parentInsnBlock = BlockUtils.getBlockByInsn(mth, parentInsn);
            if (parentInsnBlock == null) {
                throw new JadxRuntimeException("Parent insn not found in blocks tree for: " + String.valueOf(reg) + "\n insn: " + String.valueOf(parentInsn));
            }
        }
    }

    private static void checkPHI(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            ArrayList<PhiInsn> phis = new ArrayList<PhiInsn>();
            for (InsnNode insn : block.getInstructions()) {
                if (insn.getType() != InsnType.PHI) continue;
                PhiInsn phi = (PhiInsn)insn;
                phis.add(phi);
                if (phi.getArgsCount() == 0) {
                    throw new JadxRuntimeException("No args and binds in PHI");
                }
                for (InsnArg arg : insn.getArguments()) {
                    if (arg instanceof RegisterArg) {
                        BlockNode b = phi.getBlockByArg((RegisterArg)arg);
                        if (b != null) continue;
                        throw new JadxRuntimeException("Predecessor block not found");
                    }
                    throw new JadxRuntimeException("Not register in phi insn");
                }
            }
            PhiListAttr phiListAttr = block.get(AType.PHI_LIST);
            if (phiListAttr == null) {
                if (phis.isEmpty()) continue;
                throw new JadxRuntimeException("Missing PHI list attribute");
            }
            List<PhiInsn> phiList = phiListAttr.getList();
            if (phiList.isEmpty()) {
                throw new JadxRuntimeException("Empty PHI list attribute");
            }
            if (phis.containsAll(phiList) && phiList.containsAll(phis)) continue;
            throw new JadxRuntimeException("Instructions not match");
        }
        for (SSAVar ssaVar : mth.getSVars()) {
            for (PhiInsn usedInPhi : ssaVar.getUsedInPhi()) {
                boolean found = false;
                for (RegisterArg useArg : ssaVar.getUseList()) {
                    InsnNode parentInsn = useArg.getParentInsn();
                    if (parentInsn == null || parentInsn != usedInPhi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new JadxRuntimeException("Used in phi incorrect");
            }
        }
    }
}

