/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.blocks.BlockSet;
import jadx.core.utils.blocks.DFSIteration;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    private BlockUtils() {
    }

    public static BlockNode getBlockByOffset(int offset, Iterable<BlockNode> casesBlocks) {
        for (BlockNode block : casesBlocks) {
            if (block.getStartOffset() != offset) continue;
            return block;
        }
        throw new JadxRuntimeException("Can't find block by offset: " + InsnUtils.formatOffset(offset) + " in list " + String.valueOf(casesBlocks));
    }

    public static BlockNode selectOther(BlockNode node, List<BlockNode> blocks) {
        List<BlockNode> list = blocks;
        if (list.size() > 2) {
            list = BlockUtils.cleanBlockList(list);
        }
        if (list.size() != 2) {
            throw new JadxRuntimeException("Incorrect nodes count for selectOther: " + String.valueOf(node) + " in " + String.valueOf(list));
        }
        BlockNode first = list.get(0);
        if (first != node) {
            return first;
        }
        return list.get(1);
    }

    public static BlockNode selectOtherSafe(BlockNode node, List<BlockNode> blocks) {
        int size = blocks.size();
        if (size == 1) {
            BlockNode first = blocks.get(0);
            return first != node ? first : null;
        }
        if (size == 2) {
            BlockNode first = blocks.get(0);
            return first != node ? first : blocks.get(1);
        }
        return null;
    }

    public static boolean isExceptionHandlerPath(BlockNode b) {
        if (b.contains(AType.EXC_HANDLER) || b.contains(AFlag.EXC_BOTTOM_SPLITTER) || b.contains(AFlag.REMOVE)) {
            return true;
        }
        if (b.contains(AFlag.SYNTHETIC)) {
            List<BlockNode> s = b.getSuccessors();
            return s.size() == 1 && s.get(0).contains(AType.EXC_HANDLER);
        }
        return false;
    }

    private static List<BlockNode> cleanBlockList(List<BlockNode> list) {
        ArrayList<BlockNode> ret = new ArrayList<BlockNode>(list.size());
        for (BlockNode block : list) {
            if (BlockUtils.isExceptionHandlerPath(block)) continue;
            ret.add(block);
        }
        return ret;
    }

    public static void cleanBitSet(MethodNode mth, BitSet bs) {
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            BlockNode block = mth.getBasicBlocks().get(i);
            if (BlockUtils.isExceptionHandlerPath(block)) {
                bs.clear(i);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    public static boolean isBackEdge(BlockNode from, BlockNode to) {
        if (to == null) {
            return false;
        }
        if (from.getCleanSuccessors().contains(to)) {
            return false;
        }
        return from.getSuccessors().contains(to);
    }

    public static boolean isFollowBackEdge(BlockNode block) {
        BlockNode loopEndBlock;
        List<BlockNode> predecessors;
        if (block == null) {
            return false;
        }
        if (block.contains(AFlag.LOOP_START) && (predecessors = block.getPredecessors()).size() == 1 && (loopEndBlock = predecessors.get(0)).contains(AFlag.LOOP_END)) {
            List loops = loopEndBlock.getAll(AType.LOOP);
            for (LoopInfo loop : loops) {
                if (!loop.getStart().equals(block) || !loop.getEnd().equals(loopEndBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean blockContains(BlockNode block, InsnNode insn) {
        for (InsnNode bi : block.getInstructions()) {
            if (bi != insn) continue;
            return true;
        }
        return false;
    }

    public static boolean checkFirstInsn(IBlock block, Predicate<InsnNode> predicate) {
        InsnNode insn = BlockUtils.getFirstInsn(block);
        return insn != null && predicate.test(insn);
    }

    public static boolean checkLastInsnType(IBlock block, InsnType expectedType) {
        InsnNode insn = BlockUtils.getLastInsn(block);
        return insn != null && insn.getType() == expectedType;
    }

    public static InsnNode getLastInsnWithType(IBlock block, InsnType expectedType) {
        InsnNode insn = BlockUtils.getLastInsn(block);
        if (insn != null && insn.getType() == expectedType) {
            return insn;
        }
        return null;
    }

    public static int getFirstSourceLine(IBlock block) {
        for (InsnNode insn : block.getInstructions()) {
            int line = insn.getSourceLine();
            if (line == 0) continue;
            return line;
        }
        return 0;
    }

    @Nullable
    public static InsnNode getFirstInsn(@Nullable IBlock block) {
        if (block == null) {
            return null;
        }
        List<InsnNode> insns = block.getInstructions();
        if (insns.isEmpty()) {
            return null;
        }
        return insns.get(0);
    }

    @Nullable
    public static InsnNode getLastInsn(@Nullable IBlock block) {
        if (block == null) {
            return null;
        }
        List<InsnNode> insns = block.getInstructions();
        if (insns.isEmpty()) {
            return null;
        }
        return insns.get(insns.size() - 1);
    }

    public static boolean isExitBlock(MethodNode mth, BlockNode block) {
        if (block == mth.getExitBlock()) {
            return true;
        }
        return BlockUtils.isExitBlock(block);
    }

    public static boolean isExitBlock(BlockNode block) {
        List<BlockNode> successors = block.getSuccessors();
        if (successors.isEmpty()) {
            return true;
        }
        if (successors.size() == 1) {
            BlockNode next = successors.get(0);
            return next.getSuccessors().isEmpty();
        }
        return false;
    }

    public static boolean containsExitInsn(IBlock block) {
        InsnNode lastInsn = BlockUtils.getLastInsn(block);
        if (lastInsn == null) {
            return false;
        }
        InsnType type = lastInsn.getType();
        return type == InsnType.RETURN || type == InsnType.THROW || type == InsnType.BREAK || type == InsnType.CONTINUE;
    }

    @Nullable
    public static BlockNode getBlockByInsn(MethodNode mth, @Nullable InsnNode insn) {
        return BlockUtils.getBlockByInsn(mth, insn, mth.getBasicBlocks());
    }

    @Nullable
    public static BlockNode getBlockByInsn(MethodNode mth, @Nullable InsnNode insn, List<BlockNode> blocks) {
        if (insn == null) {
            return null;
        }
        if (insn instanceof PhiInsn) {
            return BlockUtils.searchBlockWithPhi(mth, (PhiInsn)insn);
        }
        if (insn.contains(AFlag.WRAPPED)) {
            return BlockUtils.getBlockByWrappedInsn(mth, insn);
        }
        for (BlockNode bn : blocks) {
            if (!BlockUtils.blockContains(bn, insn)) continue;
            return bn;
        }
        return null;
    }

    public static BlockNode searchBlockWithPhi(MethodNode mth, PhiInsn insn) {
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiListAttr = block.get(AType.PHI_LIST);
            if (phiListAttr == null) continue;
            for (PhiInsn phiInsn : phiListAttr.getList()) {
                if (phiInsn != insn) continue;
                return block;
            }
        }
        return null;
    }

    private static BlockNode getBlockByWrappedInsn(MethodNode mth, InsnNode insn) {
        for (BlockNode bn : mth.getBasicBlocks()) {
            for (InsnNode bi : bn.getInstructions()) {
                if (bi != insn && BlockUtils.foundWrappedInsn(bi, insn) == null) continue;
                return bn;
            }
        }
        return null;
    }

    public static InsnNode searchInsnParent(MethodNode mth, InsnNode insn) {
        InsnArg insnArg = BlockUtils.searchWrappedInsnParent(mth, insn);
        if (insnArg == null) {
            return null;
        }
        return insnArg.getParentInsn();
    }

    public static InsnArg searchWrappedInsnParent(MethodNode mth, InsnNode insn) {
        if (!insn.contains(AFlag.WRAPPED)) {
            return null;
        }
        for (BlockNode bn : mth.getBasicBlocks()) {
            for (InsnNode bi : bn.getInstructions()) {
                InsnArg res = BlockUtils.foundWrappedInsn(bi, insn);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private static InsnArg foundWrappedInsn(InsnNode container, InsnNode insn) {
        for (InsnArg arg : container.getArguments()) {
            if (!arg.isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            if (wrapInsn == insn) {
                return arg;
            }
            InsnArg res = BlockUtils.foundWrappedInsn(wrapInsn, insn);
            if (res == null) continue;
            return res;
        }
        if (container instanceof TernaryInsn) {
            return BlockUtils.foundWrappedInsnInCondition(((TernaryInsn)container).getCondition(), insn);
        }
        return null;
    }

    private static InsnArg foundWrappedInsnInCondition(IfCondition cond, InsnNode insn) {
        if (cond.isCompare()) {
            IfNode cmpInsn = cond.getCompare().getInsn();
            return BlockUtils.foundWrappedInsn(cmpInsn, insn);
        }
        for (IfCondition nestedCond : cond.getArgs()) {
            InsnArg res = BlockUtils.foundWrappedInsnInCondition(nestedCond, insn);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static BitSet newBlocksBitSet(MethodNode mth) {
        return new BitSet(mth.getBasicBlocks().size());
    }

    public static BitSet copyBlocksBitSet(MethodNode mth, BitSet bitSet) {
        BitSet copy = new BitSet(mth.getBasicBlocks().size());
        if (!bitSet.isEmpty()) {
            copy.or(bitSet);
        }
        return copy;
    }

    public static BitSet blocksToBitSet(MethodNode mth, Collection<BlockNode> blocks) {
        BitSet bs = BlockUtils.newBlocksBitSet(mth);
        for (BlockNode block : blocks) {
            bs.set(block.getId());
        }
        return bs;
    }

    @Nullable
    public static BlockNode bitSetToOneBlock(MethodNode mth, BitSet bs) {
        if (bs == null || bs.cardinality() != 1) {
            return null;
        }
        return mth.getBasicBlocks().get(bs.nextSetBit(0));
    }

    public static List<BlockNode> bitSetToBlocks(MethodNode mth, BitSet bs) {
        if (bs == null || bs == EmptyBitSet.EMPTY) {
            return Collections.emptyList();
        }
        int size = bs.cardinality();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(size);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            BlockNode block = mth.getBasicBlocks().get(i);
            blocks.add(block);
            i = bs.nextSetBit(i + 1);
        }
        return blocks;
    }

    public static void forEachBlockFromBitSet(MethodNode mth, BitSet bs, Consumer<BlockNode> consumer) {
        if (bs == null || bs == EmptyBitSet.EMPTY || bs.isEmpty()) {
            return;
        }
        List<BlockNode> blocks = mth.getBasicBlocks();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            consumer.accept(blocks.get(i));
            i = bs.nextSetBit(i + 1);
        }
    }

    @Nullable
    public static BlockNode getNextBlock(BlockNode block) {
        List<BlockNode> s = block.getCleanSuccessors();
        return s.isEmpty() ? null : s.get(0);
    }

    @Nullable
    public static BlockNode getPrevBlock(BlockNode block) {
        List<BlockNode> preds = block.getPredecessors();
        return preds.size() == 1 ? preds.get(0) : null;
    }

    public static BlockNode getNextBlockToPath(BlockNode block, BlockNode pathEnd) {
        List<BlockNode> successors = block.getCleanSuccessors();
        if (successors.contains(pathEnd)) {
            return pathEnd;
        }
        Set<BlockNode> path = BlockUtils.getAllPathsBlocks(block, pathEnd);
        for (BlockNode s : successors) {
            if (!path.contains(s)) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public static BlockNode getPrevBlockOnPath(MethodNode mth, BlockNode block, BlockNode pathStart) {
        BlockNode next;
        BlockSet preds = BlockSet.from(mth, block.getPredecessors());
        if (preds.contains(pathStart)) {
            return pathStart;
        }
        DFSIteration dfs = new DFSIteration(mth, pathStart, BlockNode::getCleanSuccessors);
        do {
            if ((next = dfs.next()) != null) continue;
            return null;
        } while (!preds.contains(next));
        return next;
    }

    public static boolean visitBlocksOnPath(MethodNode mth, BlockNode start, BlockNode end, Consumer<BlockNode> visitor) {
        visitor.accept(start);
        if (start == end) {
            return true;
        }
        if (start.getCleanSuccessors().contains(end)) {
            visitor.accept(end);
            return true;
        }
        BitSet visited = BlockUtils.newBlocksBitSet(mth);
        ArrayDeque<BlockNode> queue = new ArrayDeque<BlockNode>();
        queue.addLast(start);
        while (true) {
            BlockNode current;
            if ((current = (BlockNode)queue.peekLast()) == null) {
                return false;
            }
            boolean added = false;
            for (BlockNode next : current.getCleanSuccessors()) {
                if (next == end) {
                    queue.removeFirst();
                    queue.addLast(next);
                    queue.forEach(visitor);
                    return true;
                }
                int id = next.getId();
                if (visited.get(id)) continue;
                visited.set(id);
                queue.addLast(next);
                added = true;
                break;
            }
            if (added) continue;
            queue.pollLast();
            if (queue.isEmpty()) break;
        }
        return false;
    }

    public static List<BlockNode> collectAllSuccessors(MethodNode mth, BlockNode startBlock, boolean clean) {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>(mth.getBasicBlocks().size());
        Function<BlockNode, List<BlockNode>> nextFunc = clean ? BlockNode::getCleanSuccessors : BlockNode::getSuccessors;
        BlockUtils.visitDFS(mth, startBlock, nextFunc, list::add);
        return list;
    }

    public static void visitDFS(MethodNode mth, Consumer<BlockNode> visitor) {
        BlockUtils.visitDFS(mth, mth.getEnterBlock(), BlockNode::getSuccessors, visitor);
    }

    public static void visitReverseDFS(MethodNode mth, Consumer<BlockNode> visitor) {
        BlockUtils.visitDFS(mth, mth.getExitBlock(), BlockNode::getPredecessors, visitor);
    }

    private static void visitDFS(MethodNode mth, BlockNode startBlock, Function<BlockNode, List<BlockNode>> nextFunc, Consumer<BlockNode> visitor) {
        DFSIteration dfsIteration = new DFSIteration(mth, startBlock, nextFunc);
        BlockNode next;
        while ((next = dfsIteration.next()) != null) {
            visitor.accept(next);
        }
        return;
    }

    public static List<BlockNode> collectPredecessors(MethodNode mth, BlockNode start, Collection<BlockNode> stopBlocks) {
        BitSet bs = BlockUtils.newBlocksBitSet(mth);
        if (!stopBlocks.isEmpty()) {
            bs.or(BlockUtils.blocksToBitSet(mth, stopBlocks));
        }
        ArrayList<BlockNode> list = new ArrayList<BlockNode>();
        BlockUtils.traversePredecessors(start, bs, block -> {
            list.add((BlockNode)block);
            return false;
        });
        return list;
    }

    public static void visitPredecessorsUntil(MethodNode mth, BlockNode start, Predicate<BlockNode> visitor) {
        BlockUtils.traversePredecessors(start, BlockUtils.newBlocksBitSet(mth), visitor);
    }

    private static void traversePredecessors(BlockNode start, BitSet visited, Predicate<BlockNode> visitor) {
        ArrayDeque<BlockNode> queue = new ArrayDeque<BlockNode>();
        queue.add(start);
        BlockNode current;
        block0: while ((current = (BlockNode)queue.poll()) != null && !visitor.test(current)) {
            Iterator<BlockNode> iterator = current.getPredecessors().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                BlockNode next = iterator.next();
                int id = next.getId();
                if (visited.get(id)) continue;
                visited.set(id);
                queue.add(next);
            }
            break;
        }
        return;
    }

    public static Set<BlockNode> getAllPathsBlocks(BlockNode start, BlockNode end) {
        HashSet<BlockNode> set = new HashSet<BlockNode>();
        set.add(start);
        if (start != end) {
            BlockUtils.addPredecessors(set, end, start);
        }
        return set;
    }

    private static void addPredecessors(Set<BlockNode> set, BlockNode from, BlockNode until) {
        set.add(from);
        for (BlockNode pred : from.getPredecessors()) {
            if (pred == until || set.contains(pred)) continue;
            BlockUtils.addPredecessors(set, pred, until);
        }
    }

    private static boolean traverseSuccessorsUntil(BlockNode from, BlockNode until, BitSet visited, boolean clean) {
        List<BlockNode> nodes = clean ? from.getCleanSuccessors() : from.getSuccessors();
        for (BlockNode s : nodes) {
            if (s == until) {
                return true;
            }
            int id = s.getId();
            if (visited.get(id)) continue;
            visited.set(id);
            if (until.isDominator(s)) {
                return true;
            }
            if (!BlockUtils.traverseSuccessorsUntil(s, until, visited, clean)) continue;
            return true;
        }
        return false;
    }

    public static boolean atLeastOnePathExists(Collection<BlockNode> startBlocks, BlockNode end) {
        for (BlockNode startBlock : startBlocks) {
            if (!BlockUtils.isPathExists(startBlock, end)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllPathExists(Collection<BlockNode> startBlocks, BlockNode end) {
        for (BlockNode startBlock : startBlocks) {
            if (BlockUtils.isPathExists(startBlock, end)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPathExists(BlockNode start, BlockNode end) {
        if (start == end || end.isDominator(start) || start.getCleanSuccessors().contains(end)) {
            return true;
        }
        if (start.getPredecessors().contains(end)) {
            return false;
        }
        return BlockUtils.traverseSuccessorsUntil(start, end, new BitSet(), true);
    }

    public static boolean isAnyPathExists(BlockNode start, BlockNode end) {
        if (start == end || end.isDominator(start) || start.getSuccessors().contains(end)) {
            return true;
        }
        if (start.getPredecessors().contains(end)) {
            return false;
        }
        return BlockUtils.traverseSuccessorsUntil(start, end, new BitSet(), false);
    }

    public static BlockNode getTopBlock(List<BlockNode> blocks) {
        if (blocks.size() == 1) {
            return blocks.get(0);
        }
        for (BlockNode from : blocks) {
            boolean top = true;
            for (BlockNode to : blocks) {
                if (from == to || BlockUtils.isAnyPathExists(from, to)) continue;
                top = false;
                break;
            }
            if (!top) continue;
            return from;
        }
        return null;
    }

    @Nullable
    public static BlockNode getBottomBlock(List<BlockNode> blocks) {
        if (blocks.size() == 1) {
            return blocks.get(0);
        }
        for (BlockNode bottomCandidate : blocks) {
            boolean bottom = true;
            for (BlockNode from : blocks) {
                if (bottomCandidate == from || BlockUtils.isAnyPathExists(from, bottomCandidate)) continue;
                bottom = false;
                break;
            }
            if (!bottom) continue;
            return bottomCandidate;
        }
        return null;
    }

    public static boolean isOnlyOnePathExists(BlockNode start, BlockNode end) {
        if (start == end) {
            return true;
        }
        if (!end.isDominator(start)) {
            return false;
        }
        BlockNode currentNode = start;
        while (currentNode.getCleanSuccessors().size() == 1) {
            if ((currentNode = currentNode.getCleanSuccessors().get(0)) != end) continue;
            return true;
        }
        return false;
    }

    public static BlockNode traverseWhileDominates(BlockNode dom, BlockNode start) {
        for (BlockNode node : start.getCleanSuccessors()) {
            if (!node.isDominator(dom)) {
                return node;
            }
            BlockNode out = BlockUtils.traverseWhileDominates(dom, node);
            if (out == null) continue;
            return out;
        }
        return null;
    }

    @Nullable
    public static BlockNode getCommonDominator(MethodNode mth, List<BlockNode> blocks) {
        BitSet doms = BlockUtils.newBlocksBitSet(mth);
        doms.set(0, mth.getBasicBlocks().size());
        blocks.forEach(b -> doms.and(b.getDoms()));
        BitSet combine = BlockUtils.newBlocksBitSet(mth);
        combine.or(doms);
        BlockUtils.forEachBlockFromBitSet(mth, doms, block -> {
            BlockNode idom = block.getIDom();
            if (idom != null) {
                combine.andNot(idom.getDoms());
                combine.clear(idom.getId());
            }
        });
        return BlockUtils.bitSetToOneBlock(mth, combine);
    }

    @Nullable
    public static BlockNode getPathCross(MethodNode mth, Collection<BlockNode> blocks) {
        BitSet domFrontBS = BlockUtils.newBlocksBitSet(mth);
        BitSet tmpBS = BlockUtils.newBlocksBitSet(mth);
        boolean first = true;
        for (BlockNode b : blocks) {
            tmpBS.clear();
            tmpBS.set(b.getId());
            tmpBS.or(b.getDomFrontier());
            if (first) {
                domFrontBS.or(tmpBS);
                first = false;
                continue;
            }
            domFrontBS.and(tmpBS);
        }
        domFrontBS.clear(mth.getExitBlock().getId());
        if (domFrontBS.isEmpty()) {
            return null;
        }
        BlockNode oneBlock = BlockUtils.bitSetToOneBlock(mth, domFrontBS);
        if (oneBlock != null) {
            return oneBlock;
        }
        BitSet excluded = BlockUtils.newBlocksBitSet(mth);
        excluded.set(mth.getExitBlock().getId());
        mth.getLoops().forEach(l -> excluded.set(l.getStart().getId()));
        if (!mth.isNoExceptionHandlers()) {
            mth.getExceptionHandlers().forEach(h -> BlockUtils.addExcHandler(mth, h, excluded));
        }
        domFrontBS.andNot(excluded);
        oneBlock = BlockUtils.bitSetToOneBlock(mth, domFrontBS);
        if (oneBlock != null) {
            return oneBlock;
        }
        BitSet combinedDF = BlockUtils.newBlocksBitSet(mth);
        int k = mth.getBasicBlocks().size();
        while (true) {
            BlockUtils.forEachBlockFromBitSet(mth, domFrontBS, block -> {
                BitSet domFrontier = block.getDomFrontier();
                if (!domFrontier.isEmpty()) {
                    combinedDF.or(domFrontier);
                }
            });
            combinedDF.andNot(excluded);
            int cardinality = combinedDF.cardinality();
            if (cardinality == 1) {
                return BlockUtils.bitSetToOneBlock(mth, combinedDF);
            }
            if (cardinality == 0) {
                return null;
            }
            if (k-- < 0) {
                mth.addWarnComment("Path cross not found for " + String.valueOf(blocks) + ", limit reached: " + mth.getBasicBlocks().size());
                return null;
            }
            domFrontBS.clear();
            domFrontBS.or(combinedDF);
            combinedDF.clear();
        }
    }

    private static void addExcHandler(MethodNode mth, ExceptionHandler handler, BitSet set) {
        BlockNode handlerBlock = handler.getHandlerBlock();
        if (handlerBlock == null) {
            mth.addDebugComment("Null handler block in: " + String.valueOf(handler));
            return;
        }
        set.set(handlerBlock.getId());
    }

    public static BlockNode getPathCross(MethodNode mth, BlockNode b1, BlockNode b2) {
        if (b1 == b2) {
            return b1;
        }
        if (b1 == null || b2 == null) {
            return null;
        }
        return BlockUtils.getPathCross(mth, Arrays.asList(b1, b2));
    }

    public static List<BlockNode> collectBlocksDominatedBy(MethodNode mth, BlockNode dominator, BlockNode start) {
        ArrayList<BlockNode> result = new ArrayList<BlockNode>();
        BlockUtils.collectWhileDominates(dominator, start, result, BlockUtils.newBlocksBitSet(mth), false);
        return result;
    }

    public static Set<BlockNode> collectBlocksDominatedByWithExcHandlers(MethodNode mth, BlockNode dominator, BlockNode start) {
        LinkedHashSet<BlockNode> result = new LinkedHashSet<BlockNode>();
        BlockUtils.collectWhileDominates(dominator, start, result, BlockUtils.newBlocksBitSet(mth), true);
        return result;
    }

    private static void collectWhileDominates(BlockNode dominator, BlockNode child, Collection<BlockNode> result, BitSet visited, boolean includeExcHandlers) {
        if (visited.get(child.getId())) {
            return;
        }
        visited.set(child.getId());
        List<BlockNode> successors = includeExcHandlers ? child.getSuccessors() : child.getCleanSuccessors();
        for (BlockNode node : successors) {
            if (!node.isDominator(dominator)) continue;
            result.add(node);
            BlockUtils.collectWhileDominates(dominator, node, result, visited, includeExcHandlers);
        }
    }

    public static void visitSinglePath(BlockNode startBlock, Consumer<BlockNode> visitor) {
        if (startBlock == null) {
            return;
        }
        visitor.accept(startBlock);
        BlockNode next = BlockUtils.getNextSinglePathBlock(startBlock);
        while (next != null) {
            visitor.accept(next);
            next = BlockUtils.getNextSinglePathBlock(next);
        }
    }

    @Nullable
    public static BlockNode getNextSinglePathBlock(BlockNode block) {
        if (block == null || block.getPredecessors().size() > 1) {
            return null;
        }
        List<BlockNode> successors = block.getSuccessors();
        return successors.size() == 1 ? successors.get(0) : null;
    }

    public static List<BlockNode> buildSimplePath(BlockNode block) {
        if (block == null) {
            return Collections.emptyList();
        }
        ArrayList<BlockNode> list = new ArrayList<BlockNode>();
        if (block.getCleanSuccessors().size() >= 2) {
            return Collections.emptyList();
        }
        list.add(block);
        BlockNode currentBlock = BlockUtils.getNextBlock(block);
        while (currentBlock != null && currentBlock.getCleanSuccessors().size() < 2 && currentBlock.getPredecessors().size() == 1) {
            list.add(currentBlock);
            currentBlock = BlockUtils.getNextBlock(currentBlock);
        }
        return list;
    }

    public static void skipPredSyntheticPaths(BlockNode block) {
        for (BlockNode pred : block.getPredecessors()) {
            if (!pred.contains(AFlag.SYNTHETIC) || pred.contains(AFlag.EXC_TOP_SPLITTER) || pred.contains(AFlag.EXC_BOTTOM_SPLITTER) || !pred.getInstructions().isEmpty()) continue;
            pred.add(AFlag.DONT_GENERATE);
            BlockUtils.skipPredSyntheticPaths(pred);
        }
    }

    public static BlockNode followEmptyPath(BlockNode start) {
        BlockNode next;
        while ((next = BlockUtils.getNextBlockOnEmptyPath(start)) != null) {
            start = next;
        }
        return start;
    }

    public static void visitBlocksOnEmptyPath(BlockNode start, Consumer<BlockNode> visitor) {
        BlockNode next;
        while ((next = BlockUtils.getNextBlockOnEmptyPath(start)) != null) {
            visitor.accept(next);
            start = next;
        }
        return;
    }

    @Nullable
    private static BlockNode getNextBlockOnEmptyPath(BlockNode block) {
        if (!block.getInstructions().isEmpty() || block.getPredecessors().size() > 1) {
            return null;
        }
        List<BlockNode> successors = block.getCleanSuccessors();
        if (successors.size() != 1) {
            return null;
        }
        return successors.get(0);
    }

    public static boolean isEmptySimplePath(BlockNode start, BlockNode end) {
        if (start == end && start.getInstructions().isEmpty()) {
            return true;
        }
        if (!start.getInstructions().isEmpty() || start.getCleanSuccessors().size() != 1) {
            return false;
        }
        BlockNode block = BlockUtils.getNextBlock(start);
        while (block != null && block != end && block.getCleanSuccessors().size() < 2 && block.getPredecessors().size() == 1 && block.getInstructions().isEmpty()) {
            block = BlockUtils.getNextBlock(block);
        }
        return block == end;
    }

    public static BlockNode skipSyntheticPredecessor(BlockNode block) {
        if (block.isSynthetic() && block.getInstructions().isEmpty() && block.getPredecessors().size() == 1) {
            return block.getPredecessors().get(0);
        }
        return block;
    }

    public static boolean isAllBlocksEmpty(List<BlockNode> blocks) {
        if (Utils.isEmpty(blocks)) {
            return true;
        }
        for (BlockNode block : blocks) {
            if (block.getInstructions().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static List<InsnNode> collectAllInsns(List<BlockNode> blocks) {
        ArrayList<InsnNode> insns = new ArrayList<InsnNode>();
        blocks.forEach(block -> insns.addAll(block.getInstructions()));
        return insns;
    }

    public static List<InsnNode> collectInsnsWithLimit(List<BlockNode> blocks, int limit) {
        ArrayList<InsnNode> insns = new ArrayList<InsnNode>(limit);
        for (BlockNode block : blocks) {
            List<InsnNode> blockInsns = block.getInstructions();
            int blockSize = blockInsns.size();
            if (blockSize == 0) continue;
            if (insns.size() + blockSize > limit) {
                return Collections.emptyList();
            }
            insns.addAll(blockInsns);
        }
        return insns;
    }

    @Nullable
    public static InsnNode getOnlyOneInsnFromMth(MethodNode mth) {
        if (mth.isNoCode()) {
            return null;
        }
        InsnNode insn = null;
        for (BlockNode block : mth.getBasicBlocks()) {
            List<InsnNode> blockInsns = block.getInstructions();
            int blockSize = blockInsns.size();
            if (blockSize == 0) continue;
            if (blockSize > 1) {
                return null;
            }
            if (insn != null) {
                return null;
            }
            insn = blockInsns.get(0);
        }
        return insn;
    }

    public static boolean isFirstInsn(MethodNode mth, InsnNode insn) {
        BlockNode startBlock = BlockUtils.followEmptyPath(mth.getEnterBlock());
        if (startBlock != null && !startBlock.getInstructions().isEmpty()) {
            return startBlock.getInstructions().get(0) == insn;
        }
        BlockNode block = BlockUtils.getBlockByInsn(mth, insn);
        if (block == null) {
            throw new JadxRuntimeException("Insn not found in method: " + String.valueOf(insn));
        }
        if (block.getInstructions().get(0) != insn) {
            return false;
        }
        Set<BlockNode> allPathsBlocks = BlockUtils.getAllPathsBlocks(mth.getEnterBlock(), block);
        for (BlockNode pathBlock : allPathsBlocks) {
            if (pathBlock.getInstructions().isEmpty() || pathBlock == block) continue;
            return false;
        }
        return true;
    }

    public static void replaceInsn(MethodNode mth, BlockNode block, int i, InsnNode insn) {
        InsnNode prevInsn = block.getInstructions().get(i);
        insn.copyAttributesFrom(prevInsn);
        insn.inheritMetadata(prevInsn);
        insn.setOffset(prevInsn.getOffset());
        block.getInstructions().set(i, insn);
        RegisterArg result = insn.getResult();
        RegisterArg prevResult = prevInsn.getResult();
        if (result != null && prevResult != null && result.sameRegAndSVar(prevResult)) {
            InsnRemover.unbindAllArgs(mth, prevInsn);
        } else {
            InsnRemover.unbindInsn(mth, prevInsn);
        }
        insn.rebindArgs();
    }

    public static boolean replaceInsn(MethodNode mth, BlockNode block, InsnNode oldInsn, InsnNode newInsn) {
        List<InsnNode> instructions = block.getInstructions();
        int size = instructions.size();
        for (int i = 0; i < size; ++i) {
            InsnNode instruction = instructions.get(i);
            if (instruction != oldInsn) continue;
            BlockUtils.replaceInsn(mth, block, i, newInsn);
            return true;
        }
        return false;
    }

    public static boolean insertBeforeInsn(BlockNode block, InsnNode insn, InsnNode newInsn) {
        int index = BlockUtils.getInsnIndexInBlock(block, insn);
        if (index == -1) {
            return false;
        }
        block.getInstructions().add(index, newInsn);
        return true;
    }

    public static boolean insertAfterInsn(BlockNode block, InsnNode insn, InsnNode newInsn) {
        int index = BlockUtils.getInsnIndexInBlock(block, insn);
        if (index == -1) {
            return false;
        }
        block.getInstructions().add(index + 1, newInsn);
        return true;
    }

    public static int getInsnIndexInBlock(BlockNode block, InsnNode insn) {
        List<InsnNode> instructions = block.getInstructions();
        int size = instructions.size();
        for (int i = 0; i < size; ++i) {
            if (instructions.get(i) != insn) continue;
            return i;
        }
        return -1;
    }

    public static boolean replaceInsn(MethodNode mth, InsnNode oldInsn, InsnNode newInsn) {
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!BlockUtils.replaceInsn(mth, block, oldInsn, newInsn)) continue;
            return true;
        }
        return false;
    }

    public static BlockNode getTopSplitterForHandler(BlockNode handlerBlock) {
        BlockNode block = BlockUtils.getBlockWithFlag(handlerBlock.getPredecessors(), AFlag.EXC_TOP_SPLITTER);
        if (block == null) {
            throw new JadxRuntimeException("Can't find top splitter block for handler:" + String.valueOf(handlerBlock));
        }
        return block;
    }

    @Nullable
    public static BlockNode getBlockWithFlag(List<BlockNode> blocks, AFlag flag) {
        for (BlockNode block : blocks) {
            if (!block.contains(flag)) continue;
            return block;
        }
        return null;
    }

    @Nullable
    public static CatchAttr getCatchAttrForInsn(MethodNode mth, InsnNode insn) {
        CatchAttr catchAttr = insn.get(AType.EXC_CATCH);
        if (catchAttr != null) {
            return catchAttr;
        }
        BlockNode block = BlockUtils.getBlockByInsn(mth, insn);
        if (block == null) {
            return null;
        }
        return block.get(AType.EXC_CATCH);
    }

    public static boolean isEqualPaths(BlockNode b1, BlockNode b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return BlockUtils.isEqualReturnBlocks(b1, b2) || BlockUtils.isEmptySyntheticPath(b1, b2) || BlockUtils.isDuplicateBlockPath(b1, b2);
    }

    private static boolean isEmptySyntheticPath(BlockNode b1, BlockNode b2) {
        BlockNode n2;
        BlockNode n1 = BlockUtils.followEmptyPath(b1);
        return n1 == (n2 = BlockUtils.followEmptyPath(b2)) || BlockUtils.isEqualReturnBlocks(n1, n2);
    }

    public static boolean isEqualReturnBlocks(BlockNode b1, BlockNode b2) {
        InsnArg secondArg;
        if (!b1.isReturnBlock() || !b2.isReturnBlock()) {
            return false;
        }
        List<InsnNode> b1Insns = b1.getInstructions();
        List<InsnNode> b2Insns = b2.getInstructions();
        if (b1Insns.size() != 1 || b2Insns.size() != 1) {
            return false;
        }
        InsnNode i1 = b1Insns.get(0);
        InsnNode i2 = b2Insns.get(0);
        if (i1.getArgsCount() != i2.getArgsCount()) {
            return false;
        }
        if (i1.getArgsCount() == 0) {
            return true;
        }
        InsnArg firstArg = i1.getArg(0);
        if (firstArg.isSameConst(secondArg = i2.getArg(0))) {
            return true;
        }
        if (i1.getSourceLine() != i2.getSourceLine()) {
            return false;
        }
        return firstArg.equals(secondArg);
    }

    public static boolean isDuplicateBlockPath(BlockNode first, BlockNode second) {
        if (first.getSuccessors().size() == 1 && second.getSuccessors().size() == 1 && first.getSuccessors().get(0).equals(second.getSuccessors().get(0))) {
            return BlockUtils.isSameInsnsBlocks(first, second);
        }
        return false;
    }

    public static boolean isSameInsnsBlocks(BlockNode first, BlockNode second) {
        List<InsnNode> firstInsns = first.getInstructions();
        List<InsnNode> secondInsns = second.getInstructions();
        if (firstInsns.size() != secondInsns.size()) {
            return false;
        }
        int len = firstInsns.size();
        for (int i = 0; i < len; ++i) {
            InsnNode secondInsn;
            InsnNode firstInsn = firstInsns.get(i);
            if (BlockUtils.isInsnDeepEquals(firstInsn, secondInsn = secondInsns.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInsnDeepEquals(InsnNode first, InsnNode second) {
        if (first == second) {
            return true;
        }
        return first.isSame(second) && Objects.equals(first.getArguments(), second.getArguments()) && BlockUtils.resultIsSameReg(first.getResult(), second.getResult());
    }

    private static boolean resultIsSameReg(RegisterArg first, RegisterArg second) {
        if (first == null || second == null) {
            return first == second;
        }
        return first.getRegNum() == second.getRegNum();
    }
}

