/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins.files;

import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.utils.files.FileUtils;
import java.nio.file.Path;

public class SingleDirFilesGetter
implements IJadxFilesGetter {
    private final Path baseDir;

    public SingleDirFilesGetter(Path baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public Path getConfigDir() {
        return this.makeSubDir("config");
    }

    @Override
    public Path getCacheDir() {
        return this.makeSubDir("cache");
    }

    @Override
    public Path getTempDir() {
        return this.makeSubDir("temp");
    }

    private Path makeSubDir(String subDir) {
        Path dir = this.baseDir.resolve(subDir);
        FileUtils.makeDirs(dir);
        return dir;
    }
}

