/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins;

import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.data.IJadxPlugins;
import jadx.api.plugins.data.JadxPluginRuntimeData;
import jadx.core.plugins.JadxPluginManager;
import jadx.core.utils.exceptions.JadxRuntimeException;

public class JadxPluginsData
implements IJadxPlugins {
    private final JadxDecompiler decompiler;
    private final JadxPluginManager pluginManager;

    public JadxPluginsData(JadxDecompiler decompiler, JadxPluginManager pluginManager) {
        this.decompiler = decompiler;
        this.pluginManager = pluginManager;
    }

    @Override
    public JadxPluginRuntimeData getById(String pluginId) {
        return this.pluginManager.getResolvedPluginContexts().stream().filter(p -> p.getPluginId().equals(pluginId)).findFirst().orElseThrow(() -> new JadxRuntimeException("Plugin with id '" + pluginId + "' not found"));
    }

    @Override
    public JadxPluginRuntimeData getProviding(String provideId) {
        return this.pluginManager.getResolvedPluginContexts().stream().filter(p -> p.getPluginInfo().getProvides().equals(provideId)).findFirst().orElseThrow(() -> new JadxRuntimeException("Plugin providing '" + provideId + "' not found"));
    }

    @Override
    public <P extends JadxPlugin> P getInstance(Class<P> pluginCls) {
        return (P)this.pluginManager.getResolvedPluginContexts().stream().filter(p -> p.getPluginInstance().getClass().equals(pluginCls)).map(p -> p.getPluginInstance()).findFirst().orElseThrow(() -> new JadxRuntimeException("Plugin class '" + String.valueOf(pluginCls) + "' not found"));
    }
}

