/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeUpdateInfo;
import org.jetbrains.annotations.Nullable;

public final class TypeBoundInvokeAssign
implements ITypeBoundDynamic {
    private final RootNode root;
    private final InvokeNode invokeNode;
    private final ArgType genericReturnType;

    public TypeBoundInvokeAssign(RootNode root, InvokeNode invokeNode, ArgType genericReturnType) {
        this.root = root;
        this.invokeNode = invokeNode;
        this.genericReturnType = genericReturnType;
    }

    @Override
    public BoundEnum getBound() {
        return BoundEnum.ASSIGN;
    }

    @Override
    public ArgType getType(TypeUpdateInfo updateInfo) {
        return this.getReturnType(updateInfo.getType(this.getInstanceArg()));
    }

    @Override
    public ArgType getType() {
        return this.getReturnType(this.getInstanceArg().getType());
    }

    private ArgType getReturnType(ArgType instanceType) {
        IMethodDetails methodDetails = this.root.getMethodUtils().getMethodDetails(this.invokeNode);
        ArgType mthDeclType = methodDetails != null ? methodDetails.getMethodInfo().getDeclClass().getType() : instanceType;
        ArgType resultGeneric = this.root.getTypeUtils().replaceClassGenerics(instanceType, mthDeclType, this.genericReturnType);
        ArgType result = this.processResultType(resultGeneric);
        if (result != null) {
            return result;
        }
        return this.invokeNode.getCallMth().getReturnType();
    }

    @Nullable
    private ArgType processResultType(@Nullable ArgType resultGeneric) {
        if (resultGeneric == null) {
            return null;
        }
        if (!resultGeneric.isWildcard()) {
            return resultGeneric;
        }
        return resultGeneric.getWildcardType();
    }

    private InsnArg getInstanceArg() {
        return this.invokeNode.getArg(0);
    }

    @Override
    public RegisterArg getArg() {
        return this.invokeNode.getResult();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeBoundInvokeAssign that = (TypeBoundInvokeAssign)o;
        return this.invokeNode.equals(that.invokeNode);
    }

    public int hashCode() {
        return this.invokeNode.hashCode();
    }

    public String toString() {
        return "InvokeAssign{" + this.invokeNode.getCallMth().getShortId() + ", returnType=" + String.valueOf(this.genericReturnType) + ", currentType=" + String.valueOf(this.getType()) + ", instanceArg=" + String.valueOf(this.getInstanceArg()) + "}";
    }
}

