/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.maker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.EdgeInsnAttr;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.visitors.regions.maker.IfRegionMaker;
import jadx.core.dex.visitors.regions.maker.LoopRegionMaker;
import jadx.core.dex.visitors.regions.maker.RegionStack;
import jadx.core.dex.visitors.regions.maker.SwitchRegionMaker;
import jadx.core.dex.visitors.regions.maker.SynchronizedRegionMaker;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.blocks.BlockSet;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RegionMaker {
    private final MethodNode mth;
    private final RegionStack stack;
    private final IfRegionMaker ifMaker;
    private final LoopRegionMaker loopMaker;
    private final BlockSet processedBlocks;
    private final int regionsLimit;
    private int regionsCount;

    public RegionMaker(MethodNode mth) {
        this.mth = mth;
        this.stack = new RegionStack(mth);
        this.ifMaker = new IfRegionMaker(mth, this);
        this.loopMaker = new LoopRegionMaker(mth, this, this.ifMaker);
        this.processedBlocks = BlockSet.empty(mth);
        this.regionsLimit = mth.getBasicBlocks().size() * 100;
    }

    public Region makeMthRegion() {
        return this.makeRegion(this.mth.getEnterBlock());
    }

    Region makeRegion(BlockNode startBlock) {
        Objects.requireNonNull(startBlock);
        Region region = new Region(this.stack.peekRegion());
        if (this.stack.containsExit(startBlock)) {
            this.insertEdgeInsns(region, startBlock);
            return region;
        }
        if (this.processedBlocks.addChecked(startBlock)) {
            this.mth.addWarn("Removed duplicated region for block: " + String.valueOf(startBlock) + " " + startBlock.getAttributesString());
            return region;
        }
        BlockNode next = startBlock;
        while (next != null) {
            next = this.traverse(region, next);
            ++this.regionsCount;
            if (this.regionsCount <= this.regionsLimit) continue;
            throw new JadxOverflowException("Regions count limit reached");
        }
        return region;
    }

    private BlockNode traverse(IRegion r, BlockNode block) {
        if (block.contains(AFlag.MTH_EXIT_BLOCK)) {
            return null;
        }
        BlockNode next = null;
        boolean processed = false;
        List loops = block.getAll(AType.LOOP);
        int loopCount = loops.size();
        if (loopCount != 0 && block.contains(AFlag.LOOP_START)) {
            if (loopCount == 1) {
                next = this.loopMaker.process(r, (LoopInfo)loops.get(0), this.stack);
                processed = true;
            } else {
                for (LoopInfo loop : loops) {
                    if (loop.getStart() != block) continue;
                    next = this.loopMaker.process(r, loop, this.stack);
                    processed = true;
                    break;
                }
            }
        }
        InsnNode insn = BlockUtils.getLastInsn(block);
        if (!processed && insn != null) {
            switch (insn.getType()) {
                case IF: {
                    next = this.ifMaker.process(r, block, (IfNode)insn, this.stack);
                    processed = true;
                    break;
                }
                case SWITCH: {
                    SwitchRegionMaker switchMaker = new SwitchRegionMaker(this.mth, this);
                    next = switchMaker.process(r, block, (SwitchInsn)insn, this.stack);
                    processed = true;
                    break;
                }
                case MONITOR_ENTER: {
                    SynchronizedRegionMaker syncMaker = new SynchronizedRegionMaker(this.mth, this);
                    next = syncMaker.process(r, block, insn, this.stack);
                    processed = true;
                }
            }
        }
        if (!processed) {
            r.getSubBlocks().add(block);
            next = BlockUtils.getNextBlock(block);
        }
        if (next != null && !this.stack.containsExit(block) && !this.stack.containsExit(next)) {
            return next;
        }
        return null;
    }

    private void insertEdgeInsns(Region region, BlockNode exitBlock) {
        List<EdgeInsnAttr> edgeInsns = exitBlock.getAll(AType.EDGE_INSN);
        if (edgeInsns.isEmpty()) {
            return;
        }
        ArrayList<InsnNode> insns = new ArrayList<InsnNode>(edgeInsns.size());
        this.addOneInsnOfType(insns, edgeInsns, InsnType.BREAK);
        this.addOneInsnOfType(insns, edgeInsns, InsnType.CONTINUE);
        region.add(new InsnContainer(insns));
    }

    private void addOneInsnOfType(List<InsnNode> insns, List<EdgeInsnAttr> edgeInsns, InsnType insnType) {
        for (EdgeInsnAttr edgeInsn : edgeInsns) {
            InsnNode insn = edgeInsn.getInsn();
            if (insn.getType() != insnType) continue;
            insns.add(insn);
            return;
        }
    }

    RegionStack getStack() {
        return this.stack;
    }

    boolean isProcessed(BlockNode block) {
        return this.processedBlocks.contains(block);
    }

    void clearBlockProcessedState(BlockNode block) {
        this.processedBlocks.remove(block);
    }
}

