/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.fixaccessmodifiers;

import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.function.Consumer;

class VisibilityUtils {
    private final RootNode root;

    VisibilityUtils(RootNode rootNode) {
        this.root = rootNode;
    }

    void checkVisibility(ICodeNode targetNode, ICodeNode callerNode, OnBadVisibilityCallback callback) {
        ClassNode callerCls;
        ClassNode targetCls = targetNode instanceof ClassNode ? (ClassNode)targetNode : targetNode.getDeclaringClass();
        ClassNode classNode = callerCls = callerNode instanceof ClassNode ? (ClassNode)callerNode : callerNode.getDeclaringClass();
        if (targetCls.equals(callerCls) || VisibilityUtils.inSameTopClass(targetCls, callerCls)) {
            return;
        }
        if (VisibilityUtils.inSamePkg(targetCls, callerCls)) {
            VisibilityUtils.visitDeclaringNodes(targetNode, node -> {
                if (node.getAccessFlags().isPrivate()) {
                    callback.onBadVisibility((ICodeNode)node, 0);
                }
            });
        } else {
            VisibilityUtils.visitDeclaringNodes(targetNode, node -> {
                AccessInfo nodeVisFlags = node.getAccessFlags().getVisibility();
                if (nodeVisFlags.isPublic()) {
                    return;
                }
                if (nodeVisFlags.isPrivate() || nodeVisFlags.isPackagePrivate()) {
                    ClassNode nodeDeclaringCls = node.getDeclaringClass();
                    int expectedVisFlag = nodeDeclaringCls != null && this.isSuperType(callerCls, nodeDeclaringCls) ? 4 : 1;
                    callback.onBadVisibility((ICodeNode)node, expectedVisFlag);
                } else if (nodeVisFlags.isProtected()) {
                    ClassNode nodeDeclaringCls = node.getDeclaringClass();
                    if (nodeDeclaringCls == null || !this.isSuperType(callerCls, nodeDeclaringCls)) {
                        callback.onBadVisibility((ICodeNode)node, 1);
                    }
                } else {
                    throw new JadxRuntimeException(String.valueOf(nodeVisFlags) + " is not supported");
                }
            });
        }
    }

    private static void visitDeclaringNodes(ICodeNode targetNode, Consumer<ICodeNode> action) {
        ICodeNode currentNode = targetNode;
        do {
            action.accept(currentNode);
        } while ((currentNode = currentNode.getDeclaringClass()) != null);
    }

    private static boolean inSamePkg(ClassNode cls1, ClassNode cls2) {
        return cls1.getPackageNode().equals(cls2.getPackageNode());
    }

    private static boolean inSameTopClass(ClassNode cls1, ClassNode cls2) {
        return cls1.getTopParentClass().equals(cls2.getTopParentClass());
    }

    private boolean isSuperType(ClassNode cls, ClassNode superCls) {
        return this.root.getClsp().getSuperTypes(cls.getRawName()).stream().anyMatch(x -> x.equals(superCls.getRawName()));
    }

    static interface OnBadVisibilityCallback {
        public void onBadVisibility(ICodeNode var1, int var2);
    }
}

