/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.FillArrayData;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.InsnNode;
import java.util.List;
import java.util.Objects;

public final class FillArrayInsn
extends InsnNode {
    private final int target;
    private FillArrayData arrayData;

    public FillArrayInsn(InsnArg arg, int target) {
        super(InsnType.FILL_ARRAY, 1);
        this.target = target;
        this.addArg(arg);
    }

    public int getTarget() {
        return this.target;
    }

    public void setArrayData(FillArrayData arrayData) {
        this.arrayData = arrayData;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FillArrayInsn) || !super.isSame(obj)) {
            return false;
        }
        FillArrayInsn other = (FillArrayInsn)obj;
        return Objects.equals(this.arrayData, other.arrayData);
    }

    @Override
    public InsnNode copy() {
        FillArrayInsn copy = new FillArrayInsn(this.getArg(0), this.target);
        return this.copyCommonParams(copy);
    }

    @Override
    public String toString() {
        return super.toString() + ", data: " + String.valueOf(this.arrayData);
    }

    public int getSize() {
        return this.arrayData.getSize();
    }

    public ArgType getElementType() {
        return this.arrayData.getElementType();
    }

    public List<LiteralArg> getLiteralArgs(ArgType elType) {
        return this.arrayData.getLiteralArgs(elType);
    }

    public String dataToString() {
        return Objects.toString(this.arrayData);
    }
}

