/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf.conditions;

import jadx.api.deobf.IDeobfCondition;
import jadx.core.deobf.conditions.AbstractDeobfCondition;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeobfWhitelist
extends AbstractDeobfCondition {
    public static final List<String> DEFAULT_LIST = Arrays.asList("android.support.v4.*", "android.support.v7.*", "android.support.v4.os.*", "android.support.annotation.Px", "androidx.core.os.*", "androidx.annotation.Px");
    public static final String DEFAULT_STR = Utils.listToString(DEFAULT_LIST, " ");
    private final Set<String> packages = new HashSet<String>();
    private final Set<String> classes = new HashSet<String>();

    @Override
    public void init(RootNode root) {
        this.packages.clear();
        this.classes.clear();
        for (String whitelistItem : root.getArgs().getDeobfuscationWhitelist()) {
            if (whitelistItem.isEmpty()) continue;
            if (whitelistItem.endsWith(".*")) {
                this.packages.add(whitelistItem.substring(0, whitelistItem.length() - 2));
                continue;
            }
            this.classes.add(whitelistItem);
        }
    }

    @Override
    public IDeobfCondition.Action check(PackageNode pkg) {
        if (this.packages.contains(pkg.getPkgInfo().getFullName())) {
            return IDeobfCondition.Action.FORBID_RENAME;
        }
        return IDeobfCondition.Action.NO_ACTION;
    }

    @Override
    public IDeobfCondition.Action check(ClassNode cls) {
        if (this.classes.contains(cls.getClassInfo().getFullName())) {
            return IDeobfCondition.Action.FORBID_RENAME;
        }
        return IDeobfCondition.Action.NO_ACTION;
    }
}

