/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.Stream;
import se.vidstige.jadb.SyncTransport;

class Transport
implements Closeable {
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final DataInputStream dataInput;
    private final DataOutputStream dataOutput;

    private Transport(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
        this.dataOutput = new DataOutputStream(outputStream);
    }

    public Transport(Socket socket) throws IOException {
        this(socket.getOutputStream(), socket.getInputStream());
    }

    public String readString() throws IOException {
        String encodedLength = this.readString(4);
        int length = Integer.parseInt(encodedLength, 16);
        return this.readString(length);
    }

    public void readResponseTo(OutputStream output) throws IOException {
        Stream.copy(this.inputStream, output);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void verifyResponse() throws IOException, JadbException {
        String response = this.readString(4);
        if (!"OKAY".equals(response)) {
            String error = this.readString();
            throw new JadbException("command failed: " + error);
        }
    }

    public String readString(int length) throws IOException {
        byte[] responseBuffer = new byte[length];
        this.dataInput.readFully(responseBuffer);
        return new String(responseBuffer, StandardCharsets.UTF_8);
    }

    private String getCommandLength(String command) {
        return String.format("%04x", command.getBytes().length);
    }

    public void send(String command) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8);
        writer.write(this.getCommandLength(command));
        writer.write(command);
        writer.flush();
    }

    public SyncTransport startSync() throws IOException, JadbException {
        this.send("sync:");
        this.verifyResponse();
        return new SyncTransport(this.dataOutput, this.dataInput);
    }

    @Override
    public void close() throws IOException {
        this.dataInput.close();
        this.dataOutput.close();
    }
}

