/*
 * Decompiled with CFR 0.152.
 */
package com.aliucord.gradle.task.adb;

import com.aliucord.gradle.task.adb.AdbTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JvmStreamsKt;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0004J-\u0010\u0015\u001a\u00020\u000f2#\u0010\u0016\u001a\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u0012\u0004\u0012\u00020\u000f0\u0017\u00a2\u0006\u0002\b\u001bH\u0004R\u001a\u0010\u0004\u001a\u00020\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/aliucord/gradle/task/adb/DeployPrebuiltTask;", "Lcom/aliucord/gradle/task/adb/AdbTask;", "<init>", "()V", "deployType", "Lcom/aliucord/gradle/task/adb/DeployPrebuiltTask$DeployType;", "getDeployType", "()Lcom/aliucord/gradle/task/adb/DeployPrebuiltTask$DeployType;", "setDeployType", "(Lcom/aliucord/gradle/task/adb/DeployPrebuiltTask$DeployType;)V", "deployFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDeployFile", "()Lorg/gradle/api/file/RegularFileProperty;", "deploy", "", "deployCore", "file", "Ljava/io/File;", "deployPlugin", "createAliucordDirs", "editAliucordSettings", "block", "Lkotlin/Function1;", "", "Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlinx/serialization/json/JsonElement;", "Lkotlin/ExtensionFunctionType;", "DeployType", "Companion", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDeployPrebuiltTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployPrebuiltTask.kt\ncom/aliucord/gradle/task/adb/DeployPrebuiltTask\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,140:1\n80#2:141\n205#3:142\n*S KotlinDebug\n*F\n+ 1 DeployPrebuiltTask.kt\ncom/aliucord/gradle/task/adb/DeployPrebuiltTask\n*L\n115#1:141\n126#1:142\n*E\n"})
public abstract class DeployPrebuiltTask
extends AdbTask {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final ReentrantLock aliucordSettingsLock = new ReentrantLock(false);

    @Input
    @NotNull
    public abstract DeployType getDeployType();

    public abstract void setDeployType(@NotNull DeployType var1);

    @InputFile
    @NotNull
    public abstract RegularFileProperty getDeployFile();

    @TaskAction
    public final void deploy() {
        this.createAliucordDirs();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getDeployType().ordinal()]) {
            case 1: {
                File file = ((RegularFile)this.getDeployFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                this.deployCore(file);
                break;
            }
            case 2: {
                File file = ((RegularFile)this.getDeployFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                this.deployPlugin(file);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void deployCore(File file) {
        String[] stringArray = new String[3];
        stringArray[0] = "push";
        Intrinsics.checkNotNullExpressionValue((Object)file.getAbsolutePath(), (String)"getAbsolutePath(...)");
        stringArray[2] = "/storage/emulated/0/Aliucord/Aliucord.zip";
        this.runAdbCommand(stringArray);
        this.editAliucordSettings((Function1<? super Map<JsonPrimitive, JsonElement>, Unit>)((Function1)DeployPrebuiltTask::deployCore$lambda$0));
        this.getLogger().lifecycle("Deployed Aliucord core to configured devices");
    }

    private final void deployPlugin(File file) {
        String[] stringArray = new String[3];
        stringArray[0] = "push";
        Intrinsics.checkNotNullExpressionValue((Object)file.getAbsolutePath(), (String)"getAbsolutePath(...)");
        stringArray[2] = "/storage/emulated/0/Aliucord/plugins/" + file.getName();
        this.runAdbCommand(stringArray);
        this.editAliucordSettings((Function1<? super Map<JsonPrimitive, JsonElement>, Unit>)((Function1)arg_0 -> DeployPrebuiltTask.deployPlugin$lambda$1(file, arg_0)));
        this.getLogger().lifecycle("Deployed plugin " + FilesKt.getNameWithoutExtension((File)file) + " to configured devices");
    }

    protected final void createAliucordDirs() {
        String[] stringArray = new String[]{"mkdir", "-v", "-p", "'/storage/emulated/0/Aliucord/plugins'", "'/storage/emulated/0/Aliucord/themes'", "'/storage/emulated/0/Aliucord/settings'"};
        this.runAdbShell(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void editAliucordSettings(@NotNull Function1<? super Map<JsonPrimitive, JsonElement>, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        File file = this.getTemporaryDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getTemporaryDir(...)");
        File localSettingsFile = FilesKt.resolve((File)file, (String)"settings.json");
        String remoteSettingsPath = "/storage/emulated/0/Aliucord/settings/Aliucord.json";
        Lock lock = aliucordSettingsLock;
        lock.lock();
        try {
            void this_$iv;
            Map $this$decodeFromStream$iv;
            String[] stringArray;
            boolean bl = false;
            try {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "pull";
                stringArray2[1] = remoteSettingsPath;
                Intrinsics.checkNotNullExpressionValue((Object)localSettingsFile.getAbsolutePath(), (String)"getAbsolutePath(...)");
                this.runAdbCommand(stringArray2);
            }
            catch (AdbTask.AdbException e) {
                this.getLogger().info("Failed to pull Aliucord settings", (Throwable)e);
            }
            try {
                void stream$iv;
                Json e = (Json)Json.Default;
                stringArray = (String[])new FileInputStream(localSettingsFile);
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv.getSerializersModule();
                $this$decodeFromStream$iv = (Map)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)new LinkedHashMapSerializer(JsonPrimitive.Companion.serializer(), JsonElement.Companion.serializer())), (InputStream)stream$iv);
            }
            catch (Exception e) {
                this.getLogger().info("Failed to parse Aliucord settings", (Throwable)e);
                $this$decodeFromStream$iv = new LinkedHashMap();
            }
            Map settings = $this$decodeFromStream$iv;
            block.invoke((Object)settings);
            Json e = JsonKt.Json$default(null, DeployPrebuiltTask::editAliucordSettings$lambda$3$lambda$2, (int)1, null);
            Map value$iv = settings;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String newSettings = this_$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer(JsonPrimitive.Companion.serializer(), JsonElement.Companion.serializer()), (Object)value$iv);
            FilesKt.writeText$default((File)localSettingsFile, (String)newSettings, null, (int)2, null);
            stringArray = new String[3];
            stringArray[0] = "push";
            Intrinsics.checkNotNullExpressionValue((Object)localSettingsFile.getAbsolutePath(), (String)"getAbsolutePath(...)");
            stringArray[2] = remoteSettingsPath;
            String string = this.runAdbCommand(stringArray);
        }
        finally {
            lock.unlock();
        }
    }

    private static final Unit deployCore$lambda$0(Map $this$editAliucordSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$editAliucordSettings, (String)"$this$editAliucordSettings");
        $this$editAliucordSettings.put(JsonElementKt.JsonPrimitive((String)"AC_from_storage"), JsonElementKt.JsonPrimitive((Boolean)true));
        return Unit.INSTANCE;
    }

    private static final Unit deployPlugin$lambda$1(File $file, Map $this$editAliucordSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$editAliucordSettings, (String)"$this$editAliucordSettings");
        $this$editAliucordSettings.put(JsonElementKt.JsonPrimitive((String)("AC_PM_" + FilesKt.getNameWithoutExtension((File)$file))), JsonElementKt.JsonPrimitive((Boolean)true));
        return Unit.INSTANCE;
    }

    private static final Unit editAliucordSettings$lambda$3$lambda$2(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/aliucord/gradle/task/adb/DeployPrebuiltTask$Companion;", "", "<init>", "()V", "aliucordSettingsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getAliucordSettingsLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "gradle-plugin"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReentrantLock getAliucordSettingsLock() {
            return aliucordSettingsLock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/aliucord/gradle/task/adb/DeployPrebuiltTask$DeployType;", "", "<init>", "(Ljava/lang/String;I)V", "Core", "Plugin", "gradle-plugin"})
    public static final class DeployType
    extends Enum<DeployType> {
        public static final /* enum */ DeployType Core = new DeployType();
        public static final /* enum */ DeployType Plugin = new DeployType();
        private static final /* synthetic */ DeployType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DeployType[] values() {
            return (DeployType[])$VALUES.clone();
        }

        public static DeployType valueOf(String value) {
            return Enum.valueOf(DeployType.class, value);
        }

        @NotNull
        public static EnumEntries<DeployType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = deployTypeArray = new DeployType[]{DeployType.Core, DeployType.Plugin};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeployType.values().length];
            try {
                nArray[DeployType.Core.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployType.Plugin.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

