/*
 * Decompiled with CFR 0.152.
 */
package com.aliucord.gradle.task;

import com.aliucord.gradle.task.ExtractPluginClassTask;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.visitors.DexFileVisitor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0007R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/aliucord/gradle/task/ExtractPluginClassTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "inputs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "pluginClassNameFile", "Lorg/gradle/api/file/RegularFileProperty;", "getPluginClassNameFile", "()Lorg/gradle/api/file/RegularFileProperty;", "extract", "", "Companion", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nExtractPluginClassTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractPluginClassTask.kt\ncom/aliucord/gradle/task/ExtractPluginClassTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1761#2,3:104\n1761#2,3:108\n1#3:107\n*S KotlinDebug\n*F\n+ 1 ExtractPluginClassTask.kt\ncom/aliucord/gradle/task/ExtractPluginClassTask\n*L\n81#1:104,3\n57#1:108,3\n*E\n"})
public abstract class ExtractPluginClassTask
extends DefaultTask {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @NotNull
    private final ConfigurableFileCollection inputs;
    @Deprecated
    @NotNull
    public static final String PLUGIN_CLASS = "Lcom/aliucord/entities/Plugin;";
    @Deprecated
    @NotNull
    public static final String MANIFEST_CLASS = "Lcom/aliucord/entities/Plugin$Manifest";

    public ExtractPluginClassTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.inputs = configurableFileCollection;
    }

    @NotNull
    public final ConfigurableFileCollection getInputs() {
        return this.inputs;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getPluginClassNameFile();

    @TaskAction
    public final void extract() {
        boolean hasManifestOverride;
        DexClassNode pluginClass;
        block7: {
            FileTree fileTree = this.inputs.getAsFileTree();
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getAsFileTree(...)");
            Sequence readers2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)fileTree)), ExtractPluginClassTask::extract$lambda$0), (Function1)extract.readers.2.INSTANCE);
            int readerFlags = 277;
            Sequence classes = SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)readers2, arg_0 -> ExtractPluginClassTask.extract$lambda$2(readerFlags, arg_0)), ExtractPluginClassTask::extract$lambda$3);
            List pluginClasses = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)classes, ExtractPluginClassTask::extract$lambda$5));
            if (!(!((Collection)pluginClasses).isEmpty())) {
                boolean $i$a$-require-ExtractPluginClassTask$extract$52 = false;
                String $i$a$-require-ExtractPluginClassTask$extract$52 = "No classes were found annotated with @AliucordPlugin! An Aliucord plugin should have exactly one entrypoint class annotated with @AliucordPlugin.";
                throw new IllegalArgumentException($i$a$-require-ExtractPluginClassTask$extract$52.toString());
            }
            if (!(pluginClasses.size() == 1)) {
                boolean $i$a$-require-ExtractPluginClassTask$extract$62 = false;
                String $i$a$-require-ExtractPluginClassTask$extract$62 = StringsKt.trimIndent((String)("\n                More than one class was found annotated with @AliucordPlugin!\n                An Aliucord plugin should have exactly one entrypoint class annotated with @AliucordPlugin.\n\n                Found classes: " + CollectionsKt.joinToString$default((Iterable)pluginClasses, (CharSequence)" ", null, null, (int)0, null, ExtractPluginClassTask::extract$lambda$8$lambda$7, (int)30, null) + "\n            "));
                throw new IllegalArgumentException($i$a$-require-ExtractPluginClassTask$extract$62.toString());
            }
            pluginClass = (DexClassNode)CollectionsKt.single((List)pluginClasses);
            if (!Intrinsics.areEqual((Object)pluginClass.superClass, (Object)PLUGIN_CLASS)) {
                boolean $i$a$-require-ExtractPluginClassTask$extract$72 = false;
                String $i$a$-require-ExtractPluginClassTask$extract$72 = "Plugins must extend Aliucord's Plugin class! Class " + pluginClass.className + " was found to be overriding " + pluginClass.superClass;
                throw new IllegalArgumentException($i$a$-require-ExtractPluginClassTask$extract$72.toString());
            }
            List list = pluginClass.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"methods");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DexMethodNode it = (DexMethodNode)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.method.getName(), (Object)"getManifest") && Intrinsics.areEqual((Object)it.method.getDesc(), (Object)"()Lcom/aliucord/entities/Plugin$Manifest"))) continue;
                    v2 = true;
                    break block7;
                }
                v2 = hasManifestOverride = false;
            }
        }
        if (!(!hasManifestOverride)) {
            boolean bl = false;
            String string = "Plugins cannot override getManifest()! Class " + pluginClass.className + " was found to be overriding getManifest()!";
            throw new IllegalArgumentException(string.toString());
        }
        String string = pluginClass.className;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        String pluginClassName = StringsKt.replace$default((String)StringsKt.removeSurrounding((String)string, (CharSequence)"L", (CharSequence)";"), (char)'/', (char)'.', (boolean)false, (int)4, null);
        File file = ((RegularFile)this.getPluginClassNameFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        FilesKt.writeText$default((File)file, (String)pluginClassName, null, (int)2, null);
    }

    private static final boolean extract$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"dex");
    }

    private static final DexFileNode extract$lambda$2(int $readerFlags, DexFileReader reader) {
        DexFileNode dexFileNode;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        DexFileNode node = dexFileNode = new DexFileNode();
        boolean bl = false;
        reader.accept((DexFileVisitor)node, $readerFlags);
        return dexFileNode;
    }

    private static final Iterable extract$lambda$3(DexFileNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.clzs;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"clzs");
        return list;
    }

    private static final boolean extract$lambda$5(DexClassNode cls) {
        boolean bl;
        List list = cls.anns;
        if (list != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DexAnnotationNode ann = (DexAnnotationNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)ann.type, (Object)"Lcom/aliucord/annotations/AliucordPlugin;")) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final CharSequence extract$lambda$8$lambda$7(DexClassNode it) {
        String string = it.className;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/aliucord/gradle/task/ExtractPluginClassTask$Companion;", "", "<init>", "()V", "PLUGIN_CLASS", "", "MANIFEST_CLASS", "gradle-plugin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

