/*
 * Decompiled with CFR 0.152.
 */
package com.aliucord.gradle.task.adb;

import com.aliucord.gradle.ConstantsKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\"\u00020\u000bH\u0004\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J!\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\"\u00020\u000bH\u0004\u00a2\u0006\u0002\u0010\u001dR&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000b8G@GX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/aliucord/gradle/task/adb/AdbTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "value", "", "waitForDebugger", "getWaitForDebugger", "()Z", "setWaitForDebugger", "(Z)V", "", "deviceSerial", "getDeviceSerial", "()Ljava/lang/String;", "setDeviceSerial", "(Ljava/lang/String;)V", "adbExecutable", "Ljava/io/File;", "runAdbShell", "", "args", "", "([Ljava/lang/String;)V", "emulatorSerial", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getAllSerials", "", "runAdbCommand", "([Ljava/lang/String;)Ljava/lang/String;", "AdbException", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAdbTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbTask.kt\ncom/aliucord/gradle/task/adb/AdbTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1#2:137\n1#2:152\n1563#3:138\n1634#3,3:139\n1617#3,9:142\n1869#3:151\n1870#3:153\n1626#3:154\n*S KotlinDebug\n*F\n+ 1 AdbTask.kt\ncom/aliucord/gradle/task/adb/AdbTask\n*L\n99#1:152\n95#1:138\n95#1:139,3\n99#1:142,9\n99#1:151\n99#1:153\n99#1:154\n*E\n"})
public abstract class AdbTask
extends DefaultTask {
    private boolean waitForDebugger;
    @Optional
    @Nullable
    private String deviceSerial;
    @NotNull
    private final File adbExecutable;

    public AdbTask() {
        ExtensionContainer extensionContainer = this.getProject().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
        this.adbExecutable = ConstantsKt.getAndroid(extensionContainer).getAdbExecutable();
    }

    @Input
    public final boolean getWaitForDebugger() {
        return this.waitForDebugger;
    }

    @Option(option="wait-for-debugger", description="Enables debugging flag when starting the discord activity")
    public final void setWaitForDebugger(boolean bl) {
        this.waitForDebugger = bl;
    }

    @Input
    @Nullable
    public final String getDeviceSerial() {
        return this.deviceSerial;
    }

    @Option(option="device-serial", description="The serial number of the device to deploy to, or a list of comma-separated serials. Set this to 'all' to deploy to all connected devices. If not set, then this defaults to any *single* connected device.")
    public final void setDeviceSerial(@Nullable String string) {
        this.deviceSerial = string;
    }

    protected final void runAdbShell(String ... args) {
        List list;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String serialConfig = this.deviceSerial;
        List allSerials = this.getAllSerials();
        String string = serialConfig;
        if (string == null) {
            if (!(allSerials.size() == 1)) {
                boolean bl = false;
                String string2 = "Only one ADB device should be connected, but " + allSerials.size() + " were!";
                throw new IllegalArgumentException(string2.toString());
            }
            list = CollectionsKt.listOf((Object)CollectionsKt.first(allSerials));
        } else if (Intrinsics.areEqual((Object)string, (Object)"all")) {
            list = allSerials;
        } else {
            Object object = new char[]{','};
            List expectedSerials = StringsKt.split$default((CharSequence)serialConfig, (char[])object, (boolean)false, (int)0, (int)6, null);
            if (!(!((Collection)expectedSerials).isEmpty())) {
                boolean $i$a$-require-AdbTask$runAdbShell$serials$42 = false;
                String $i$a$-require-AdbTask$runAdbShell$serials$42 = "No device serials provided to deploy to!";
                throw new IllegalArgumentException($i$a$-require-AdbTask$runAdbShell$serials$42.toString());
            }
            object = expectedSerials.iterator();
            while (object.hasNext()) {
                String expectedSerial = (String)object.next();
                if (allSerials.contains(expectedSerial)) continue;
                boolean bl = false;
                String string3 = "Device " + expectedSerial + " is not connected!";
                throw new IllegalArgumentException(string3.toString());
            }
            list = expectedSerials;
        }
        List serials = list;
        for (String serial : serials) {
            this.getLogger().info("Running command on device " + serial);
            this.runAdbShell(serial, Arrays.copyOf(args, args.length));
        }
    }

    private final String runAdbShell(String emulatorSerial, String ... args) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)"-s");
        spreadBuilder.add((Object)emulatorSerial);
        spreadBuilder.add((Object)"shell");
        spreadBuilder.addSpread((Object)args);
        return this.runAdbCommand((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllSerials() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"devices"};
        String output = this.runAdbCommand(stringArray);
        Iterable $this$map$iv = CollectionsKt.drop((Iterable)StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)output)).toString()), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List devices = (List)destination$iv$iv;
        Regex regex = new Regex("\\s+");
        Iterable $this$mapNotNull$iv = devices;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = it;
            int n = 0;
            List values = regex.split(charSequence, n);
            if (values.size() != 2) {
                this.getLogger().info("adb devices returned unexpected output: " + values);
            }
            if (Intrinsics.areEqual(values.get(1), (Object)"device")) {
                this.getLogger().info("Found device: " + values.get(0));
                string = (String)values.get(0);
            } else {
                this.getLogger().info("Found inactive device: " + values.get(0) + " status: " + values.get(1));
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    protected final String runAdbCommand(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this.adbExecutable.getAbsolutePath());
        spreadBuilder.addSpread((Object)args);
        Process adbProcess = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])).start();
        try {
            adbProcess.waitFor(60L, TimeUnit.SECONDS);
            if (adbProcess.exitValue() != 0) {
                String string = ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                BufferedReader bufferedReader = adbProcess.errorReader();
                Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"errorReader(...)");
                throw new AdbException("adb exited with a non-zero exit code. Command: adb " + string + " Error: " + TextStreamsKt.readText((Reader)bufferedReader));
            }
            BufferedReader bufferedReader = adbProcess.inputReader();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"inputReader(...)");
            return TextStreamsKt.readText((Reader)bufferedReader);
        }
        catch (InterruptedException interruptedException) {
            adbProcess.destroy();
            throw new AdbException("adb command timed out. adb " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/aliucord/gradle/task/adb/AdbTask$AdbException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "error", "", "<init>", "(Ljava/lang/String;)V", "gradle-plugin"})
    protected static final class AdbException
    extends Exception {
        public AdbException(@NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(error);
        }
    }
}

