/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import java.io.IOException;
import java.io.Writer;

public final class Utf8Utils {
    private static char[] tempBuffer = null;

    private Utf8Utils() {
        throw new UnsupportedOperationException();
    }

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                bytes[outAt] = (byte)c;
                ++outAt;
                continue;
            }
            if (c < '\u0800') {
                bytes[outAt] = (byte)(c >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(byte[] bytes, int start, int length) {
        if (tempBuffer == null || tempBuffer.length < length) {
            tempBuffer = new char[length];
        }
        char[] chars = tempBuffer;
        int outAt = 0;
        int at = start;
        while (length > 0) {
            char out;
            int v0 = bytes[at] & 0xFF;
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v0 == 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    out = (char)v0;
                    ++at;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    int v1 = bytes[at + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    out = (char)value;
                    at += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    int v1 = bytes[at + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    int v2 = bytes[at + 2] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v2, at + 2);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v2, at + 2);
                    }
                    out = (char)value;
                    at += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v0, at);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + String.format("%02x", value) + " at offset " + String.format("%08x", offset));
    }

    public static void writeEscapedChar(Writer writer, char c) throws IOException {
        if (c >= ' ' && c < '\u007f') {
            if (c == '\'' || c == '\"' || c == '\\') {
                writer.write(92);
            }
            writer.write(c);
            return;
        }
        if (c <= '\u007f') {
            switch (c) {
                case '\n': {
                    writer.write("\\n");
                    return;
                }
                case '\r': {
                    writer.write("\\r");
                    return;
                }
                case '\t': {
                    writer.write("\\t");
                    return;
                }
            }
        }
        writer.write("\\u");
        writer.write(Character.forDigit(c >> 12, 16));
        writer.write(Character.forDigit(c >> 8 & 0xF, 16));
        writer.write(Character.forDigit(c >> 4 & 0xF, 16));
        writer.write(Character.forDigit(c & 0xF, 16));
    }

    /*
     * Unable to fully structure code
     */
    public static void writeEscapedString(Writer writer, String value) throws IOException {
        block5: for (i = 0; i < value.length(); ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    writer.write(92);
                }
                writer.write(c);
                continue;
            }
            if (c > '\u007f') ** GOTO lbl-1000
            switch (c) {
                case '\n': {
                    writer.write("\\n");
                    continue block5;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block5;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    writer.write("\\u");
                    writer.write(Character.forDigit(c >> 12, 16));
                    writer.write(Character.forDigit(c >> 8 & 15, 16));
                    writer.write(Character.forDigit(c >> 4 & 15, 16));
                    writer.write(Character.forDigit(c & 15, 16));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String escapeString(String value) {
        len = value.length();
        sb = new StringBuilder(len * 3 / 2);
        block5: for (i = 0; i < len; ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
                continue;
            }
            if (c > '\u007f') ** GOTO lbl-1000
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append("\\u");
                    sb.append(Character.forDigit(c >> 12, 16));
                    sb.append(Character.forDigit(c >> 8 & 15, 16));
                    sb.append(Character.forDigit(c >> 4 & 15, 16));
                    sb.append(Character.forDigit(c & 15, 16));
                }
            }
        }
        return sb.toString();
    }
}

